/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionSetter;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionCopier {
    public static void copyOptions(Object origObject, Object destObject) throws ConfigurationException {
        Collection<Field> origFields = OptionSetter.getOptionFieldsForClass(origObject.getClass());
        Map<String, Field> destFieldMap = OptionCopier.getFieldOptionMap(destObject);
        for (Field origField : origFields) {
            Option option = origField.getAnnotation(Option.class);
            Field destField = destFieldMap.remove(option.name());
            if (destField == null) continue;
            Object origValue = OptionSetter.getFieldValue(origField, origObject);
            OptionSetter.setFieldValue(option.name(), destObject, destField, origValue);
        }
    }

    private static Map<String, Field> getFieldOptionMap(Object destObject) {
        Collection<Field> destFields = OptionSetter.getOptionFieldsForClass(destObject.getClass());
        HashMap<String, Field> fieldMap = new HashMap<String, Field>(destFields.size());
        for (Field field : destFields) {
            Option o = field.getAnnotation(Option.class);
            fieldMap.put(o.name(), field);
        }
        return fieldMap;
    }
}

