/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.SimpleStats;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CpuStatsCollector
extends Thread {
    private static final String CPU_STATS_CMD = "cpustats -m -d %s";
    private final ITestDevice mTestDevice;
    private long mDelay;
    private CpuStatsReceiver mReceiver = new CpuStatsReceiver();

    public CpuStatsCollector(ITestDevice testDevice) {
        this(testDevice, 1);
    }

    public CpuStatsCollector(ITestDevice testDevice, int delay) {
        this.mTestDevice = testDevice;
        this.mDelay = delay;
    }

    public void logToFile(File logFile) {
        this.mReceiver.logToFile(logFile);
    }

    public synchronized void cancel() {
        this.mReceiver.cancel();
    }

    public synchronized boolean isCancelled() {
        return this.mReceiver.isCancelled();
    }

    @Override
    public void run() {
        try {
            this.mTestDevice.executeShellCommand(String.format(CPU_STATS_CMD, this.mDelay), (IShellOutputReceiver)this.mReceiver);
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.e("Device %s not available: %s", this.mTestDevice.getSerialNumber(), e.getMessage());
        }
    }

    public Map<String, List<CpuStats>> getCpuStats() {
        return this.mReceiver.getCpuStats();
    }

    public static Double getTotalPercentageMean(List<CpuStats> cpuStats) {
        SimpleStats stats = new SimpleStats();
        for (CpuStats s : cpuStats) {
            if (s.getTotalUsage() == null) continue;
            stats.add(s.getTotalUsage());
        }
        return 100.0 * stats.mean();
    }

    public static Double getUserPercentageMean(List<CpuStats> cpuStats) {
        return CpuStatsCollector.getPercentageMean(cpuStats, TimeCategory.USER) + CpuStatsCollector.getPercentageMean(cpuStats, TimeCategory.NICE);
    }

    public static Double getSystemPercentageMean(List<CpuStats> cpuStats) {
        return CpuStatsCollector.getPercentageMean(cpuStats, TimeCategory.SYS);
    }

    public static Double getIowPercentageMean(List<CpuStats> cpuStats) {
        return CpuStatsCollector.getPercentageMean(cpuStats, TimeCategory.IOW);
    }

    public static Double getIrqPercentageMean(List<CpuStats> cpuStats) {
        return CpuStatsCollector.getPercentageMean(cpuStats, TimeCategory.IRQ) + CpuStatsCollector.getPercentageMean(cpuStats, TimeCategory.SIRQ);
    }

    public static Double getEstimatedMhzMean(List<CpuStats> cpuStats) {
        SimpleStats stats = new SimpleStats();
        for (CpuStats s : cpuStats) {
            if (s.mFreqStats.isEmpty()) continue;
            stats.add(s.getEstimatedMhz());
        }
        return stats.mean();
    }

    public static Double getUsedMhzPercentageMean(List<CpuStats> cpuStats) {
        SimpleStats stats = new SimpleStats();
        for (CpuStats s : cpuStats) {
            if (s.mFreqStats.isEmpty()) continue;
            stats.add(s.getUsedMhzPercentage());
        }
        return stats.mean();
    }

    private static Double getPercentageMean(List<CpuStats> cpuStats, TimeCategory category) {
        SimpleStats stats = new SimpleStats();
        for (CpuStats s : cpuStats) {
            stats.add(s.getPercentage(category));
        }
        return stats.mean();
    }

    CpuStatsReceiver getReceiver() {
        return this.mReceiver;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CpuStatsReceiver
    extends MultiLineReceiver {
        private Map<String, List<CpuStats>> mCpuStats = new HashMap<String, List<CpuStats>>(4);
        private boolean mIsCancelled = false;
        private File mLogFile = null;
        private BufferedWriter mLogWriter = null;

        public CpuStatsReceiver() {
            this.setTrimLine(false);
        }

        public synchronized void logToFile(File logFile) {
            try {
                this.mLogFile = logFile;
                this.mLogWriter = new BufferedWriter(new FileWriter(this.mLogFile));
            }
            catch (IOException e) {
                LogUtil.CLog.e("Error creating file: %s", e.getMessage());
                this.mLogWriter = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processNewLines(String[] lines) {
            if (this.mIsCancelled) {
                return;
            }
            CpuStatsReceiver cpuStatsReceiver = this;
            synchronized (cpuStatsReceiver) {
                if (this.mLogWriter != null) {
                    try {
                        for (String line : lines) {
                            this.mLogWriter.write(line + "\n");
                        }
                    }
                    catch (IOException e) {
                        LogUtil.CLog.e("Error writing to file: %s", e.getMessage());
                    }
                }
            }
            for (String line : lines) {
                String[] args = line.trim().split(",");
                if (args.length >= 8) {
                    try {
                        CpuStats s = new CpuStats();
                        s.mTimeStats.put(TimeCategory.USER, Integer.parseInt(args[1]));
                        s.mTimeStats.put(TimeCategory.NICE, Integer.parseInt(args[2]));
                        s.mTimeStats.put(TimeCategory.SYS, Integer.parseInt(args[3]));
                        s.mTimeStats.put(TimeCategory.IDLE, Integer.parseInt(args[4]));
                        s.mTimeStats.put(TimeCategory.IOW, Integer.parseInt(args[5]));
                        s.mTimeStats.put(TimeCategory.IRQ, Integer.parseInt(args[6]));
                        s.mTimeStats.put(TimeCategory.SIRQ, Integer.parseInt(args[7]));
                        int i = 0;
                        while (i + 8 < args.length) {
                            s.mFreqStats.put(Integer.parseInt(args[8 + i]), Integer.parseInt(args[9 + i]));
                            i += 2;
                        }
                        CpuStatsReceiver cpuStatsReceiver2 = this;
                        synchronized (cpuStatsReceiver2) {
                            if (!this.mCpuStats.containsKey(args[0])) {
                                this.mCpuStats.put(args[0], new LinkedList());
                            }
                            this.mCpuStats.get(args[0]).add(s);
                        }
                    }
                    catch (NumberFormatException e) {
                        LogUtil.CLog.w("Unexpected input: %s", line.trim());
                    }
                    catch (IndexOutOfBoundsException e) {
                        LogUtil.CLog.w("Unexpected input: %s", line.trim());
                    }
                    continue;
                }
                if (args.length <= 1 && "".equals(args[0])) continue;
                LogUtil.CLog.w("Unexpected input: %s", line.trim());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void cancel() {
            if (this.mIsCancelled) {
                return;
            }
            this.mIsCancelled = true;
            if (this.mLogWriter != null) {
                try {
                    this.mLogWriter.flush();
                    this.mLogWriter.close();
                }
                catch (IOException e) {
                    LogUtil.CLog.e("Error closing writer %s", e.getMessage());
                }
                finally {
                    this.mLogWriter = null;
                }
            }
        }

        public synchronized boolean isCancelled() {
            return this.mIsCancelled;
        }

        public synchronized Map<String, List<CpuStats>> getCpuStats() {
            HashMap<String, List<CpuStats>> copy = new HashMap<String, List<CpuStats>>(this.mCpuStats.size());
            for (String k : this.mCpuStats.keySet()) {
                copy.put(k, new ArrayList(this.mCpuStats.get(k)));
            }
            return copy;
        }
    }

    public static class CpuStats {
        public Map<TimeCategory, Integer> mTimeStats = new HashMap<TimeCategory, Integer>();
        public Map<Integer, Integer> mFreqStats = new HashMap<Integer, Integer>();
        private Map<TimeCategory, Double> mPercentageStats = new HashMap<TimeCategory, Double>();
        private Integer mTotalTime = null;
        private Double mAverageMhz = null;

        public Double getPercentage(TimeCategory category) {
            if (!this.mPercentageStats.containsKey((Object)category)) {
                this.mPercentageStats.put(category, 100.0 * (double)this.mTimeStats.get((Object)category).intValue() / (double)this.getTotalTime().intValue());
            }
            return this.mPercentageStats.get((Object)category);
        }

        public Double getEstimatedMhz() {
            if (this.mFreqStats.isEmpty()) {
                return null;
            }
            return this.getTotalUsage() * this.getAverageMhz();
        }

        public Double getUsedMhzPercentage() {
            if (this.mFreqStats.isEmpty()) {
                return null;
            }
            return 100.0 * this.getAverageMhz() / this.getMaxMhz();
        }

        private Double getTotalUsage() {
            return (double)(this.getTotalTime() - this.mTimeStats.get((Object)TimeCategory.IDLE)) / (double)this.getTotalTime().intValue();
        }

        private Double getAverageMhz() {
            if (this.mFreqStats.isEmpty()) {
                return null;
            }
            if (this.mAverageMhz == null) {
                double sumFreqTime = 0.0;
                long sumTime = 0L;
                for (Map.Entry<Integer, Integer> e : this.mFreqStats.entrySet()) {
                    sumFreqTime += (double)(e.getKey() * e.getValue()) / 1000.0;
                    sumTime += (long)e.getValue().intValue();
                }
                this.mAverageMhz = sumFreqTime / (double)sumTime;
            }
            return this.mAverageMhz;
        }

        private Double getMaxMhz() {
            if (this.mFreqStats.isEmpty()) {
                return null;
            }
            int max = 0;
            for (int freq : this.mFreqStats.keySet()) {
                max = Math.max(max, freq);
            }
            return (double)max / 1000.0;
        }

        private Integer getTotalTime() {
            if (this.mTotalTime == null) {
                int sum = 0;
                for (int time : this.mTimeStats.values()) {
                    sum += time;
                }
                this.mTotalTime = sum;
            }
            return this.mTotalTime;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TimeCategory {
        USER,
        NICE,
        SYS,
        IDLE,
        IOW,
        IRQ,
        SIRQ;

    }
}

