/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.IDevice;
import com.android.tradefed.device.IDeviceMonitor;
import com.android.tradefed.log.LogUtil;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceMonitorAsyncProxy
implements IDeviceMonitor {
    private final BlockingQueue<Runnable> mRunnableQueue = new LinkedBlockingQueue<Runnable>();
    private Dispatcher mDispatcher;
    private IDeviceMonitor mChildMonitor;

    public DeviceMonitorAsyncProxy(IDeviceMonitor monitor) {
        this.mChildMonitor = monitor;
        if (this.mChildMonitor == null) {
            this.mDispatcher = null;
            return;
        }
        this.mDispatcher = new Dispatcher(this.mRunnableQueue);
    }

    @Override
    public void run() {
        if (this.mDispatcher != null) {
            this.mDispatcher.start();
            this.mRunnableQueue.add(new Runnable(){

                public void run() {
                    DeviceMonitorAsyncProxy.this.mChildMonitor.run();
                }
            });
        }
    }

    @Override
    public void setDeviceLister(final IDeviceMonitor.DeviceLister lister) {
        if (this.mChildMonitor == null || this.mDispatcher == null) {
            return;
        }
        this.mRunnableQueue.add(new Runnable(){

            public void run() {
                DeviceMonitorAsyncProxy.this.mChildMonitor.setDeviceLister(lister);
            }
        });
    }

    @Override
    public void setHostLabels(final Collection<String> labels) {
        if (this.mChildMonitor == null || this.mDispatcher == null) {
            return;
        }
        this.mRunnableQueue.add(new Runnable(){

            public void run() {
                DeviceMonitorAsyncProxy.this.mChildMonitor.setHostLabels(labels);
            }
        });
    }

    @Override
    public void updateFullDeviceState() {
        if (this.mChildMonitor == null || this.mDispatcher == null) {
            return;
        }
        this.mRunnableQueue.add(new Runnable(){

            public void run() {
                DeviceMonitorAsyncProxy.this.mChildMonitor.updateFullDeviceState();
            }
        });
    }

    @Override
    public void deviceAllocated(final IDevice device) {
        if (this.mChildMonitor == null || this.mDispatcher == null) {
            return;
        }
        this.mRunnableQueue.add(new Runnable(){

            public void run() {
                DeviceMonitorAsyncProxy.this.mChildMonitor.deviceAllocated(device);
            }
        });
    }

    public void cancel() {
        if (this.mChildMonitor == null || this.mDispatcher == null) {
            return;
        }
        this.mDispatcher.cancel();
        this.mDispatcher = null;
        this.mChildMonitor = null;
    }

    Dispatcher getDispatcher() {
        return this.mDispatcher;
    }

    BlockingQueue<Runnable> getRunnableQueue() {
        return this.mRunnableQueue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Dispatcher
    extends Thread {
        private final BlockingQueue<Runnable> mRunnableQueue;
        private boolean mCanceled = false;

        Dispatcher(BlockingQueue<Runnable> q) {
            this.mRunnableQueue = q;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            Runnable runner = null;
            while (!this.mCanceled) {
                try {
                    runner = this.mRunnableQueue.take();
                    runner.run();
                }
                catch (InterruptedException e) {
                }
                catch (RuntimeException e) {
                    LogUtil.CLog.e("Encountered an exception; this will break device monitoring");
                    LogUtil.CLog.e(e);
                    throw e;
                }
            }
        }

        public void cancel() {
            this.mCanceled = true;
            this.mRunnableQueue.add(new Runnable(){

                public void run() {
                }
            });
        }
    }
}

