/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.tradefed.log.LogUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DumpsysPackageParser {
    private static final String HIDDEN_SYSTEM_PACKAGES_PREFIX = "Hidden system packages:";
    private static final String PACKAGE_START = "Package\\s\\[";
    private static final Pattern PKG_DATA_PATTERN = Pattern.compile("^([\\w\\.]+)\\].*pkgFlags=0x([0-9a-fA-F]+)", 32);
    private static final Pattern PKG_DATA_STRING_PATTERN = Pattern.compile("^([\\w\\.]+)\\].*pkgFlags=\\[([\\w\\s]+)\\]", 32);
    private static final Pattern HIDDEN_PKG_PATTERN = Pattern.compile("^([\\w\\.]+)\\]", 32);
    private static final int FLAG_UPDATED_SYSTEM_APP = 128;
    private static final int FLAG_SYSTEM = 1;
    private static final String FLAG_UPDATED_SYSTEM_APP_TEXT = " UPDATED_SYSTEM_APP ";
    private static final String FLAG_SYSTEM_TEXT = " SYSTEM ";
    private Map<String, PackageInfo> mPkgInfoMap = new HashMap<String, PackageInfo>();

    DumpsysPackageParser() {
    }

    public static DumpsysPackageParser parse(String data) throws ParseException {
        DumpsysPackageParser p = new DumpsysPackageParser();
        p.doParse(data);
        return p;
    }

    void doParse(String data) throws ParseException {
        int hiddenPkgIndex = data.lastIndexOf(HIDDEN_SYSTEM_PACKAGES_PREFIX);
        if (hiddenPkgIndex == -1) {
            hiddenPkgIndex = data.length() - 1;
        }
        String packageData = data.substring(0, hiddenPkgIndex);
        String hiddenPkgData = data.substring(hiddenPkgIndex, data.length() - 1);
        this.parsePackagesData(packageData);
        this.parseHiddenSystemPackages(hiddenPkgData);
    }

    private void parsePackagesData(String data) throws ParseException {
        String[] pkgTexts;
        for (String pkgText : pkgTexts = data.split(PACKAGE_START)) {
            PackageInfo p = this.parsePackageData(pkgText);
            if (p == null) continue;
            this.mPkgInfoMap.put(p.packageName, p);
        }
    }

    PackageInfo parsePackageData(String pkgText) throws ParseException {
        PackageInfo p = this.parsePackageDataNumericFlags(pkgText);
        if (p == null) {
            p = this.parsePackageDataStringFlags(pkgText);
        }
        return p;
    }

    private PackageInfo parsePackageDataNumericFlags(String pkgText) throws ParseException {
        Matcher matcher = PKG_DATA_PATTERN.matcher(pkgText);
        if (matcher.find()) {
            String name = matcher.group(1);
            int flags = this.parseHexInt(matcher.group(2));
            boolean isSystem = (flags & 1) != 0;
            boolean isUpdatedSystem = (flags & 0x80) != 0;
            return new PackageInfo(name, isSystem, isUpdatedSystem);
        }
        return null;
    }

    private PackageInfo parsePackageDataStringFlags(String pkgText) {
        Matcher matcher = PKG_DATA_STRING_PATTERN.matcher(pkgText);
        if (matcher.find()) {
            String name = matcher.group(1);
            String flagString = matcher.group(2);
            boolean isSystem = flagString.contains(FLAG_SYSTEM_TEXT);
            boolean isUpdatedSystem = flagString.contains(FLAG_UPDATED_SYSTEM_APP_TEXT);
            return new PackageInfo(name, isSystem, isUpdatedSystem);
        }
        return null;
    }

    private int parseHexInt(String s) throws ParseException {
        try {
            return Integer.parseInt(s, 16);
        }
        catch (NumberFormatException e) {
            throw new ParseException(String.format("Unexpected flags value %s", s), e);
        }
    }

    private void parseHiddenSystemPackages(String s) {
        String[] pkgTexts;
        for (String pkgText : pkgTexts = s.split(PACKAGE_START)) {
            Matcher matcher = HIDDEN_PKG_PATTERN.matcher(pkgText);
            if (!matcher.find()) continue;
            String name = matcher.group(1);
            PackageInfo p = this.mPkgInfoMap.get(name);
            if (p != null) {
                p.isUpdatedSystemApp = true;
                continue;
            }
            LogUtil.CLog.w("Failed to find package info for hidden system package %s", name);
        }
    }

    public Collection<PackageInfo> getPackages() {
        return this.mPkgInfoMap.values();
    }

    static class ParseException
    extends IOException {
        ParseException(String msg) {
            super(msg);
        }

        ParseException(String msg, Throwable t) {
            super(msg, t);
        }
    }

    static class PackageInfo {
        final String packageName;
        final boolean isSystemApp;
        boolean isUpdatedSystemApp;

        PackageInfo(String pkgName, boolean systemApp, boolean updatedSystemApp) {
            this.packageName = pkgName;
            this.isSystemApp = systemApp;
            this.isUpdatedSystemApp = updatedSystemApp;
        }
    }
}

