/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.testrunner.IRemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.IDeviceRecovery;
import com.android.tradefed.device.IFileEntry;
import com.android.tradefed.device.TestDeviceOptions;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.util.CommandResult;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ITestDevice {
    public void setRecovery(IDeviceRecovery var1);

    public void setRecoveryMode(RecoveryMode var1);

    public RecoveryMode getRecoveryMode();

    public IDevice getIDevice();

    public String getSerialNumber();

    public String getProductType() throws DeviceNotAvailableException;

    public String getProductVariant() throws DeviceNotAvailableException;

    public String getFastbootProductType() throws DeviceNotAvailableException;

    public String getFastbootProductVariant() throws DeviceNotAvailableException;

    public String getBootloaderVersion() throws DeviceNotAvailableException;

    public String getBuildId();

    public String getProperty(String var1) throws DeviceNotAvailableException;

    public String getPropertySync(String var1) throws DeviceNotAvailableException;

    public void executeShellCommand(String var1, IShellOutputReceiver var2) throws DeviceNotAvailableException;

    public void executeShellCommand(String var1, IShellOutputReceiver var2, int var3, int var4) throws DeviceNotAvailableException;

    public String executeShellCommand(String var1) throws DeviceNotAvailableException;

    public String executeAdbCommand(String ... var1) throws DeviceNotAvailableException;

    public CommandResult executeFastbootCommand(String ... var1) throws DeviceNotAvailableException;

    public CommandResult executeLongFastbootCommand(String ... var1) throws DeviceNotAvailableException;

    public boolean getUseFastbootErase();

    public void setUseFastbootErase(boolean var1);

    public CommandResult fastbootWipePartition(String var1) throws DeviceNotAvailableException;

    public boolean runInstrumentationTests(IRemoteAndroidTestRunner var1, Collection<ITestRunListener> var2) throws DeviceNotAvailableException;

    public boolean runInstrumentationTests(IRemoteAndroidTestRunner var1, ITestRunListener ... var2) throws DeviceNotAvailableException;

    public String installPackage(File var1, boolean var2, String ... var3) throws DeviceNotAvailableException;

    public String uninstallPackage(String var1) throws DeviceNotAvailableException;

    public String getMountPoint(String var1);

    public List<MountPointInfo> getMountPointInfo() throws DeviceNotAvailableException;

    public MountPointInfo getMountPointInfo(String var1) throws DeviceNotAvailableException;

    public InputStreamSource getBugreport();

    public boolean pullFile(String var1, File var2) throws DeviceNotAvailableException;

    public File pullFile(String var1) throws DeviceNotAvailableException;

    public File pullFileFromExternal(String var1) throws DeviceNotAvailableException;

    public boolean pushFile(File var1, String var2) throws DeviceNotAvailableException;

    public boolean pushString(String var1, String var2) throws DeviceNotAvailableException;

    public boolean pushDir(File var1, String var2) throws DeviceNotAvailableException;

    public boolean syncFiles(File var1, String var2) throws DeviceNotAvailableException;

    public boolean doesFileExist(String var1) throws DeviceNotAvailableException;

    public long getExternalStoreFreeSpace() throws DeviceNotAvailableException;

    public IFileEntry getFileEntry(String var1) throws DeviceNotAvailableException;

    public void clearLogcat();

    public InputStreamSource getLogcat();

    public InputStreamSource getLogcat(int var1);

    public InputStreamSource getLogcatDump();

    public InputStreamSource getScreenshot() throws DeviceNotAvailableException;

    public boolean connectToWifiNetwork(String var1, String var2) throws DeviceNotAvailableException;

    public boolean disconnectFromWifi() throws DeviceNotAvailableException;

    public String getIpAddress() throws DeviceNotAvailableException;

    public boolean clearErrorDialogs() throws DeviceNotAvailableException;

    public void rebootIntoBootloader() throws DeviceNotAvailableException;

    public void reboot() throws DeviceNotAvailableException;

    public void rebootIntoRecovery() throws DeviceNotAvailableException;

    public void rebootUntilOnline() throws DeviceNotAvailableException;

    public void nonBlockingReboot() throws DeviceNotAvailableException;

    public boolean enableAdbRoot() throws DeviceNotAvailableException;

    public TestDeviceState getDeviceState();

    public boolean encryptDevice(boolean var1) throws DeviceNotAvailableException, UnsupportedOperationException;

    public boolean unencryptDevice() throws DeviceNotAvailableException, UnsupportedOperationException;

    public boolean unlockDevice() throws DeviceNotAvailableException, UnsupportedOperationException;

    public boolean isDeviceEncrypted() throws DeviceNotAvailableException;

    public boolean isEncryptionSupported() throws DeviceNotAvailableException;

    public void waitForDeviceAvailable(long var1) throws DeviceNotAvailableException;

    public void waitForDeviceAvailable() throws DeviceNotAvailableException;

    public void waitForDeviceOnline(long var1) throws DeviceNotAvailableException;

    public void waitForDeviceOnline() throws DeviceNotAvailableException;

    public boolean waitForDeviceNotAvailable(long var1);

    public boolean waitForDeviceInRecovery(long var1);

    public void postBootSetup() throws DeviceNotAvailableException;

    public boolean isAdbTcp();

    public boolean isAdbRoot() throws DeviceNotAvailableException;

    public String switchToAdbTcp() throws DeviceNotAvailableException;

    public boolean switchToAdbUsb() throws DeviceNotAvailableException;

    public void setOptions(TestDeviceOptions var1);

    public TestDeviceOptions getOptions();

    public Set<String> getInstalledPackageNames() throws DeviceNotAvailableException;

    public Set<String> getUninstallablePackageNames() throws DeviceNotAvailableException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MountPointInfo {
        public String filesystem;
        public String mountpoint;
        public String type;
        public List<String> options;

        public MountPointInfo() {
        }

        public MountPointInfo(String filesystem, String mountpoint, String type, List<String> options) {
            this.filesystem = filesystem;
            this.mountpoint = mountpoint;
            this.type = type;
            this.options = options;
        }

        public MountPointInfo(String filesystem, String mountpoint, String type, String optString) {
            this(filesystem, mountpoint, type, MountPointInfo.splitMountOptions(optString));
        }

        public static List<String> splitMountOptions(String options) {
            List<String> list = Arrays.asList(options.split(","));
            return list;
        }

        public String toString() {
            return String.format("%s %s %s %s", this.filesystem, this.mountpoint, this.type, this.options);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RecoveryMode {
        NONE,
        ONLINE,
        AVAILABLE;

    }
}

