/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ByteArrayInputStreamSource;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.SnapshotInputStreamSource;
import com.android.tradefed.util.FixedByteArrayOutputStream;
import com.android.tradefed.util.SizeLimitedOutputStream;
import com.android.tradefed.util.StreamUtil;
import java.io.IOException;
import java.io.InputStream;

public class LargeOutputReceiver
implements IShellOutputReceiver {
    private String mSerialNumber;
    private String mDescriptor;
    private boolean mIsCancelled = false;
    private SizeLimitedOutputStream mOutStream;
    private long mMaxDataSize;

    public LargeOutputReceiver(String descriptor, String serialNumber, long maxDataSize) {
        this.mDescriptor = descriptor;
        this.mSerialNumber = serialNumber;
        this.mMaxDataSize = maxDataSize;
        this.mOutStream = this.createOutputStream();
    }

    public synchronized void addOutput(byte[] data, int offset, int length) {
        if (this.mIsCancelled || this.mOutStream == null) {
            return;
        }
        try {
            this.mOutStream.write(data, offset, length);
        }
        catch (IOException e) {
            LogUtil.CLog.w("failed to write %s data for %s.", this.mDescriptor, this.mSerialNumber);
        }
    }

    public synchronized InputStreamSource getData() {
        if (this.mOutStream != null) {
            try {
                return new SnapshotInputStreamSource(this.mOutStream.getData());
            }
            catch (IOException e) {
                LogUtil.CLog.e("failed to get %s data for %s.", this.mDescriptor, this.mSerialNumber);
                LogUtil.CLog.e(e);
            }
        }
        return new ByteArrayInputStreamSource(new byte[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized InputStreamSource getData(int maxBytes) {
        if (this.mOutStream != null) {
            InputStream fullStream = null;
            try {
                fullStream = this.mOutStream.getData();
                final FixedByteArrayOutputStream os = new FixedByteArrayOutputStream(maxBytes);
                StreamUtil.copyStreams(fullStream, os);
                InputStreamSource inputStreamSource = new InputStreamSource(){

                    public InputStream createInputStream() {
                        return os.getData();
                    }

                    public void cancel() {
                    }

                    public long size() {
                        return os.size();
                    }
                };
                return inputStreamSource;
            }
            catch (IOException e) {
                LogUtil.CLog.e("failed to get %s data for %s.", this.mDescriptor, this.mSerialNumber);
                LogUtil.CLog.e(e);
            }
            finally {
                StreamUtil.close(fullStream);
            }
        }
        return new ByteArrayInputStreamSource(new byte[0]);
    }

    public synchronized void flush() {
        if (this.mOutStream == null) {
            return;
        }
        this.mOutStream.flush();
    }

    public synchronized void clear() {
        this.delete();
        this.mOutStream = this.createOutputStream();
    }

    private SizeLimitedOutputStream createOutputStream() {
        return new SizeLimitedOutputStream(this.mMaxDataSize, String.format("%s_%s", this.getDescriptor(), this.mSerialNumber), ".txt");
    }

    public synchronized void cancel() {
        this.mIsCancelled = true;
    }

    public void delete() {
        this.mOutStream.delete();
        this.mOutStream = null;
    }

    public synchronized boolean isCancelled() {
        return this.mIsCancelled;
    }

    String getDescriptor() {
        return this.mDescriptor;
    }
}

