/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.tradefed.device.BackgroundDeviceAction;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.LargeOutputReceiver;
import com.android.tradefed.result.InputStreamSource;

public class LogcatReceiver {
    private BackgroundDeviceAction mDeviceAction;
    private LargeOutputReceiver mReceiver;
    static final String LOGCAT_CMD = "logcat -v threadtime";
    private static final String LOGCAT_DESC = "logcat";

    public LogcatReceiver(ITestDevice device, long maxFileSize, int logStartDelay) {
        this.mReceiver = new LargeOutputReceiver(LOGCAT_DESC, device.getSerialNumber(), maxFileSize);
        this.mDeviceAction = new BackgroundDeviceAction(LOGCAT_CMD, LOGCAT_DESC, device, this.mReceiver, logStartDelay);
    }

    public void start() {
        this.mDeviceAction.start();
    }

    public void stop() {
        this.mDeviceAction.cancel();
        this.mReceiver.cancel();
        this.mReceiver.delete();
    }

    public InputStreamSource getLogcatData() {
        return this.mReceiver.getData();
    }

    public InputStreamSource getLogcatData(int maxBytes) {
        return this.mReceiver.getData(maxBytes);
    }

    public void clear() {
        this.mReceiver.clear();
    }
}

