/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.TimeoutException;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceUnresponsiveException;
import com.android.tradefed.device.IDeviceRecovery;
import com.android.tradefed.device.IDeviceStateMonitor;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.io.IOException;

public class WaitDeviceRecovery
implements IDeviceRecovery {
    private static final String LOG_TAG = "WaitDeviceRecovery";
    protected static final long INITIAL_PAUSE_TIME = 5000L;
    public static final int BOOTLOADER_POLL_ATTEMPTS = 3;
    @Option(name="device-wait-time", description="maximum time in ms to wait for a single device recovery command.")
    protected long mWaitTime = 240000L;
    @Option(name="bootloader-wait-time", description="maximum time in ms to wait for device to be in fastboot.")
    protected long mBootloaderWaitTime = 30000L;
    @Option(name="shell-wait-time", description="maximum time in ms to wait for device shell to be responsive.")
    protected long mShellWaitTime = 30000L;

    protected IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    void setWaitTime(long waitTime) {
        this.mWaitTime = waitTime;
    }

    public void recoverDevice(IDeviceStateMonitor monitor, boolean recoverUntilOnline) throws DeviceNotAvailableException {
        IDevice device;
        Log.i((String)LOG_TAG, (String)String.format("Pausing for %d for %s to recover", 5000L, monitor.getSerialNumber()));
        this.getRunUtil().sleep(5000L);
        monitor.waitForDeviceBootloaderStateUpdate();
        if (monitor.getDeviceState().equals((Object)TestDeviceState.FASTBOOT)) {
            Log.i((String)LOG_TAG, (String)String.format("Found device %s in fastboot but expected online. Rebooting...", monitor.getSerialNumber()));
            this.getRunUtil().runTimedCmd(20000L, "fastboot", "-s", monitor.getSerialNumber(), "reboot");
        }
        if ((device = monitor.waitForDeviceOnline()) == null) {
            this.handleDeviceNotAvailable(monitor, recoverUntilOnline);
            return;
        }
        if (!monitor.waitForDeviceShell(this.mShellWaitTime)) {
            this.handleDeviceNotAvailable(monitor, recoverUntilOnline);
            return;
        }
        if (!recoverUntilOnline && monitor.waitForDeviceAvailable(this.mWaitTime) == null) {
            this.handleDeviceUnresponsive(device, monitor);
        }
    }

    protected void handleDeviceUnresponsive(IDevice device, IDeviceStateMonitor monitor) throws DeviceNotAvailableException {
        this.rebootDevice(device);
        IDevice newdevice = monitor.waitForDeviceOnline();
        if (newdevice == null) {
            this.handleDeviceNotAvailable(monitor, false);
            return;
        }
        if (monitor.waitForDeviceAvailable(this.mWaitTime) == null) {
            throw new DeviceUnresponsiveException(String.format("Device %s is online but unresponsive", monitor.getSerialNumber()));
        }
    }

    protected void handleDeviceNotAvailable(IDeviceStateMonitor monitor, boolean recoverTillOnline) throws DeviceNotAvailableException {
        throw new DeviceNotAvailableException(String.format("Could not find device %s", monitor.getSerialNumber()));
    }

    public void recoverDeviceBootloader(IDeviceStateMonitor monitor) throws DeviceNotAvailableException {
        Log.i((String)LOG_TAG, (String)String.format("Pausing for %d for %s to recover", 5000L, monitor.getSerialNumber()));
        this.getRunUtil().sleep(5000L);
        long pollTime = this.mBootloaderWaitTime / 3L;
        for (int i = 0; i < 3; ++i) {
            if (monitor.waitForDeviceBootloader(pollTime)) {
                this.handleDeviceBootloaderUnresponsive(monitor);
                return;
            }
            if (monitor.getDeviceState() != TestDeviceState.ONLINE) continue;
            this.handleDeviceOnlineExpectedBootloader(monitor);
            return;
        }
        this.handleDeviceBootloaderNotAvailable(monitor);
    }

    protected void handleDeviceOnlineExpectedBootloader(IDeviceStateMonitor monitor) throws DeviceNotAvailableException {
        Log.i((String)LOG_TAG, (String)String.format("Found device %s online but expected fastboot.", monitor.getSerialNumber()));
        IDevice device = monitor.waitForDeviceOnline();
        if (device == null) {
            this.handleDeviceBootloaderNotAvailable(monitor);
            return;
        }
        this.rebootDeviceIntoBootloader(device);
        if (!monitor.waitForDeviceBootloader(this.mBootloaderWaitTime)) {
            throw new DeviceNotAvailableException(String.format("Device %s not in bootloader after reboot", monitor.getSerialNumber()));
        }
    }

    protected void handleDeviceBootloaderUnresponsive(IDeviceStateMonitor monitor) throws DeviceNotAvailableException {
        LogUtil.CLog.i("Found device %s in fastboot but potentially unresponsive.", monitor.getSerialNumber());
        this.getRunUtil().runTimedCmd(20000L, "fastboot", "-s", monitor.getSerialNumber(), "reboot-bootloader");
        monitor.waitForDeviceNotAvailable(20000L);
        if (!monitor.waitForDeviceBootloader(this.mBootloaderWaitTime)) {
            throw new DeviceNotAvailableException(String.format("Device %s not in bootloader after reboot", monitor.getSerialNumber()));
        }
    }

    protected void rebootDeviceIntoBootloader(IDevice device) {
        try {
            device.reboot("bootloader");
        }
        catch (IOException e) {
            Log.w((String)LOG_TAG, (String)String.format("failed to reboot %s: %s", device.getSerialNumber(), e.getMessage()));
        }
        catch (TimeoutException e) {
            Log.w((String)LOG_TAG, (String)String.format("failed to reboot %s: timeout", device.getSerialNumber()));
        }
        catch (AdbCommandRejectedException e) {
            Log.w((String)LOG_TAG, (String)String.format("failed to reboot %s: %s", device.getSerialNumber(), e.getMessage()));
        }
    }

    protected void rebootDevice(IDevice device) {
        try {
            device.reboot(null);
        }
        catch (IOException e) {
            Log.w((String)LOG_TAG, (String)String.format("failed to reboot %s: %s", device.getSerialNumber(), e.getMessage()));
        }
        catch (TimeoutException e) {
            Log.w((String)LOG_TAG, (String)String.format("failed to reboot %s: timeout", device.getSerialNumber()));
        }
        catch (AdbCommandRejectedException e) {
            Log.w((String)LOG_TAG, (String)String.format("failed to reboot %s: %s", device.getSerialNumber(), e.getMessage()));
        }
    }

    protected void handleDeviceBootloaderNotAvailable(IDeviceStateMonitor monitor) throws DeviceNotAvailableException {
        throw new DeviceNotAvailableException(String.format("Could not find device %s in bootloader", monitor.getSerialNumber()));
    }

    public void recoverDeviceRecovery(IDeviceStateMonitor monitor) throws DeviceNotAvailableException {
        throw new DeviceNotAvailableException("device recovery not implemented");
    }
}

