/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.IWifiHelper;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WifiHelper
implements IWifiHelper {
    private static final String NULL_IP_ADDR = "0.0.0.0";
    private static final String INSTRUMENTATION_CLASS = ".WifiUtil";
    private static final String INSTRUMENTATION_PKG = "com.android.tradefed.utils.wifi";
    static final String FULL_INSTRUMENTATION_NAME = String.format("%s/%s", "com.android.tradefed.utils.wifi", ".WifiUtil");
    static final String CHECK_INSTRUMENTATION_CMD = String.format("pm list instrumentation %s", "com.android.tradefed.utils.wifi");
    private static final String WIFIUTIL_APK_NAME = "WifiUtil.apk";
    private static final long DEFAULT_WIFI_STATE_TIMEOUT = 30000L;
    private final ITestDevice mDevice;

    public WifiHelper(ITestDevice device) throws TargetSetupError, DeviceNotAvailableException {
        this.mDevice = device;
        this.ensureDeviceSetup();
    }

    IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    void ensureDeviceSetup() throws TargetSetupError, DeviceNotAvailableException {
        String inst = this.mDevice.executeShellCommand(CHECK_INSTRUMENTATION_CMD);
        if (inst != null && inst.contains(FULL_INSTRUMENTATION_NAME)) {
            return;
        }
        File apkTempFile = null;
        try {
            apkTempFile = FileUtil.createTempFile(WIFIUTIL_APK_NAME, ".apk");
            InputStream apkStream = this.getClass().getResourceAsStream(String.format("/apks/wifiutil/%s", WIFIUTIL_APK_NAME));
            FileUtil.writeToFile(apkStream, apkTempFile);
            String result = this.mDevice.installPackage(apkTempFile, false, new String[0]);
            if (result == null) {
                return;
            }
            try {
                throw new TargetSetupError(String.format("Unable to install WifiUtil utility: %s", result));
            }
            catch (IOException e) {
                throw new TargetSetupError(String.format("Failed to unpack WifiUtil utility: %s", e.getMessage()));
            }
        }
        finally {
            FileUtil.deleteFile(apkTempFile);
        }
    }

    @Override
    public boolean enableWifi() throws DeviceNotAvailableException {
        return WifiHelper.asBool(this.runWifiUtil("enableWifi", new String[0]));
    }

    @Override
    public boolean disableWifi() throws DeviceNotAvailableException {
        return WifiHelper.asBool(this.runWifiUtil("disableWifi", new String[0]));
    }

    @Override
    public boolean waitForWifiState(IWifiHelper.WifiState ... expectedStates) throws DeviceNotAvailableException {
        return this.waitForWifiState(30000L, expectedStates);
    }

    boolean waitForWifiState(long timeout, IWifiHelper.WifiState ... expectedStates) throws DeviceNotAvailableException {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() < startTime + timeout) {
            String state = this.runWifiUtil("getSupplicantState", new String[0]);
            for (IWifiHelper.WifiState expectedState : expectedStates) {
                if (!expectedState.name().equals(state)) continue;
                return true;
            }
            this.getRunUtil().sleep(this.getPollTime());
        }
        return false;
    }

    long getPollTime() {
        return 1000L;
    }

    void removeNetwork(int networkId) throws DeviceNotAvailableException {
        this.runWifiUtil("removeNetwork", "id", Integer.toString(networkId));
    }

    @Override
    public boolean addOpenNetwork(String ssid) throws DeviceNotAvailableException {
        int id = WifiHelper.asInt(this.runWifiUtil("addOpenNetwork", "ssid", ssid));
        if (id < 0) {
            return false;
        }
        if (!WifiHelper.asBool(this.runWifiUtil("associateNetwork", "id", Integer.toString(id)))) {
            return false;
        }
        return WifiHelper.asBool(this.runWifiUtil("saveConfiguration", new String[0]));
    }

    @Override
    public boolean addWpaPskNetwork(String ssid, String psk) throws DeviceNotAvailableException {
        int id = WifiHelper.asInt(this.runWifiUtil("addWpaPskNetwork", "ssid", ssid, "psk", psk));
        if (id < 0) {
            return false;
        }
        if (!WifiHelper.asBool(this.runWifiUtil("associateNetwork", "id", Integer.toString(id)))) {
            return false;
        }
        return WifiHelper.asBool(this.runWifiUtil("saveConfiguration", new String[0]));
    }

    @Override
    public boolean waitForIp(long timeout) throws DeviceNotAvailableException {
        if (!WifiHelper.asBool(this.runWifiUtil("isWifiEnabled", new String[0]))) {
            return false;
        }
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() < startTime + timeout) {
            String ip = this.getIpAddress();
            if (ip != null && !ip.isEmpty() && !NULL_IP_ADDR.equals(ip)) {
                return true;
            }
            this.getRunUtil().sleep(this.getPollTime());
        }
        return false;
    }

    @Override
    public String getIpAddress() throws DeviceNotAvailableException {
        return this.runWifiUtil("getIpAddress", new String[0]);
    }

    @Override
    public void removeAllNetworks() throws DeviceNotAvailableException {
        this.runWifiUtil("removeAllNetworks", new String[0]);
    }

    @Override
    public boolean isWifiEnabled() throws DeviceNotAvailableException {
        return WifiHelper.asBool(this.runWifiUtil("isWifiEnabled", new String[0]));
    }

    @Override
    public boolean waitForWifiEnabled() throws DeviceNotAvailableException {
        return this.waitForWifiEnabled(30000L);
    }

    @Override
    public boolean waitForWifiEnabled(long timeout) throws DeviceNotAvailableException {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() < startTime + timeout) {
            if (this.isWifiEnabled()) {
                return true;
            }
            this.getRunUtil().sleep(this.getPollTime());
        }
        return false;
    }

    private String runWifiUtil(String method, String ... args) throws DeviceNotAvailableException {
        String cmd = WifiHelper.buildWifiUtilCmd(method, args);
        WifiUtilOutput parser = new WifiUtilOutput();
        this.mDevice.executeShellCommand(cmd, (IShellOutputReceiver)parser);
        return parser.getResult();
    }

    static String buildWifiUtilCmd(String method, String ... args) {
        HashMap<String, String> argMap = new HashMap<String, String>();
        argMap.put("method", method);
        if ((args.length & 1) == 1) {
            throw new IllegalArgumentException("args should have even length, consisting of key and value pairs");
        }
        for (int i = 0; i < args.length; i += 2) {
            argMap.put(args[i], args[i + 1]);
        }
        return WifiHelper.buildWifiUtilCmdFromMap(argMap);
    }

    static String buildWifiUtilCmdFromMap(Map<String, String> args) {
        StringBuilder sb = new StringBuilder("am instrument");
        for (Map.Entry<String, String> arg : args.entrySet()) {
            sb.append(" -e ");
            sb.append(arg.getKey());
            sb.append(" ");
            sb.append(WifiHelper.quote(arg.getValue()));
        }
        sb.append(" -w ");
        sb.append(INSTRUMENTATION_PKG);
        sb.append("/");
        sb.append(INSTRUMENTATION_CLASS);
        return sb.toString();
    }

    private static int asInt(String str) {
        if (str == null) {
            return -1;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static boolean asBool(String str) {
        return "true".equals(str);
    }

    private static String quote(String str) {
        return String.format("\"%s\"", str);
    }

    private static class WifiUtilOutput
    extends MultiLineReceiver {
        private static final Pattern RESULT_PAT = Pattern.compile("INSTRUMENTATION_RESULT: result=(.*)");
        private String mResult = null;

        private WifiUtilOutput() {
        }

        public void processNewLines(String[] lines) {
            for (String line : lines) {
                Matcher resultMatcher = RESULT_PAT.matcher(line);
                if (!resultMatcher.matches()) continue;
                this.mResult = resultMatcher.group(1);
            }
        }

        String getResult() {
            return this.mResult;
        }

        public boolean isCancelled() {
            return false;
        }
    }
}

