/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.log;

import com.android.ddmlib.Log;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.log.ILeveledLogOutput;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ByteArrayInputStreamSource;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.SnapshotInputStreamSource;
import com.android.tradefed.util.SizeLimitedOutputStream;
import com.android.tradefed.util.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@OptionClass(alias="file")
public class FileLogger
implements ILeveledLogOutput {
    private static final String TEMP_FILE_PREFIX = "tradefed_log_";
    private static final String TEMP_FILE_SUFFIX = ".txt";
    @Option(name="log-level", description="the minimum log level to log.")
    private Log.LogLevel mLogLevel = Log.LogLevel.DEBUG;
    @Option(name="log-level-display", shortName=108, description="the minimum log level to display on stdout.", importance=Option.Importance.ALWAYS)
    private Log.LogLevel mLogLevelDisplay = Log.LogLevel.ERROR;
    @Option(name="log-tag-display", description="Always display given tags logs on stdout")
    private Collection<String> mLogTagsDisplay = new HashSet<String>();
    @Option(name="max-log-size", description="maximum allowable size of tmp log data in mB.")
    private long mMaxLogSizeMbytes = 20L;
    private SizeLimitedOutputStream mLogStream;

    void addLogTagsDisplay(Collection<String> tags) {
        this.mLogTagsDisplay.addAll(tags);
    }

    @Override
    public void init() throws IOException {
        this.mLogStream = new SizeLimitedOutputStream(this.mMaxLogSizeMbytes * 1024L * 1024L, TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
    }

    @Override
    public ILeveledLogOutput clone() {
        FileLogger logger = new FileLogger();
        logger.setLogLevelDisplay(this.mLogLevelDisplay);
        logger.setLogLevel(this.mLogLevel);
        logger.addLogTagsDisplay(this.mLogTagsDisplay);
        return logger;
    }

    public void printAndPromptLog(Log.LogLevel logLevel, String tag, String message) {
        this.internalPrintLog(logLevel, tag, message, true);
    }

    public void printLog(Log.LogLevel logLevel, String tag, String message) {
        this.internalPrintLog(logLevel, tag, message, false);
    }

    private void internalPrintLog(Log.LogLevel logLevel, String tag, String message, boolean forceStdout) {
        String outMessage = LogUtil.getLogFormatString(logLevel, tag, message);
        if (forceStdout || logLevel.getPriority() >= this.mLogLevelDisplay.getPriority() || this.mLogTagsDisplay.contains(tag)) {
            System.out.print(outMessage);
        }
        try {
            this.writeToLog(outMessage);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void writeToLog(String outMessage) throws IOException {
        if (this.mLogStream != null) {
            this.mLogStream.write(outMessage.getBytes());
        }
    }

    @Override
    public Log.LogLevel getLogLevel() {
        return this.mLogLevel;
    }

    @Override
    public void setLogLevel(Log.LogLevel logLevel) {
        this.mLogLevel = logLevel;
    }

    void setLogLevelDisplay(Log.LogLevel logLevel) {
        this.mLogLevelDisplay = logLevel;
    }

    Log.LogLevel getLogLevelDisplay() {
        return this.mLogLevelDisplay;
    }

    @Override
    public InputStreamSource getLog() {
        if (this.mLogStream != null) {
            try {
                this.mLogStream.flush();
                return new SnapshotInputStreamSource(this.mLogStream.getData());
            }
            catch (IOException e) {
                System.err.println("Failed to get log");
                e.printStackTrace();
            }
        }
        return new ByteArrayInputStreamSource(new byte[0]);
    }

    @Override
    public void closeLog() {
        try {
            this.doCloseLog();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doCloseLog() throws IOException {
        SizeLimitedOutputStream stream = this.mLogStream;
        this.mLogStream = null;
        if (stream != null) {
            try {
                stream.flush();
                stream.close();
                Object var3_2 = null;
                stream.delete();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                stream.delete();
                throw throwable;
            }
        }
    }

    void dumpToLog(InputStream inputStream) throws IOException {
        if (this.mLogStream != null) {
            StreamUtil.copyStreams(inputStream, this.mLogStream);
        }
    }
}

