/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.log;

import com.android.ddmlib.Log;
import com.android.tradefed.log.FileLogger;
import com.android.tradefed.log.ILeveledLogOutput;
import com.android.tradefed.log.ILogRegistry;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.StreamUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogRegistry
implements ILogRegistry {
    private static final String LOG_TAG = "LogRegistry";
    private static LogRegistry mLogRegistry = null;
    private Map<ThreadGroup, ILeveledLogOutput> mLogTable = new Hashtable<ThreadGroup, ILeveledLogOutput>();
    private FileLogger mGlobalLogger;

    LogRegistry() {
        try {
            this.mGlobalLogger = new FileLogger();
            this.mGlobalLogger.init();
        }
        catch (IOException e) {
            System.err.println("Failed to create global logger");
            throw new IllegalStateException(e);
        }
    }

    public static ILogRegistry getLogRegistry() {
        if (mLogRegistry == null) {
            mLogRegistry = new LogRegistry();
        }
        return mLogRegistry;
    }

    @Override
    public void setGlobalLogDisplayLevel(Log.LogLevel logLevel) {
        this.mGlobalLogger.setLogLevelDisplay(logLevel);
    }

    @Override
    public void setGlobalLogTagDisplay(Collection<String> logTagsDisplay) {
        this.mGlobalLogger.addLogTagsDisplay(logTagsDisplay);
    }

    @Override
    public Log.LogLevel getGlobalLogDisplayLevel() {
        return this.mGlobalLogger.getLogLevelDisplay();
    }

    @Override
    public void registerLogger(ILeveledLogOutput log) {
        ILeveledLogOutput oldValue = this.mLogTable.put(this.getCurrentThreadGroup(), log);
        if (oldValue != null) {
            Log.e((String)LOG_TAG, (String)"Registering a new logger when one already exists for this thread!");
            oldValue.closeLog();
        }
    }

    @Override
    public void unregisterLogger() {
        ThreadGroup currentThreadGroup = this.getCurrentThreadGroup();
        if (currentThreadGroup != null) {
            this.mLogTable.remove(currentThreadGroup);
        } else {
            this.printLog(Log.LogLevel.ERROR, LOG_TAG, "Unregistering when thread has no logger registered.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpToGlobalLog(ILeveledLogOutput log) {
        InputStreamSource source = log.getLog();
        try {
            try {
                InputStream stream = source.createInputStream();
                this.mGlobalLogger.dumpToLog(stream);
                StreamUtil.close(stream);
            }
            catch (IOException e) {
                System.err.println("Failed to dump log");
                e.printStackTrace();
                Object var5_6 = null;
                source.cancel();
            }
            Object var5_5 = null;
            source.cancel();
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            source.cancel();
            throw throwable;
        }
    }

    ThreadGroup getCurrentThreadGroup() {
        return Thread.currentThread().getThreadGroup();
    }

    public void printLog(Log.LogLevel logLevel, String tag, String message) {
        ILeveledLogOutput log = this.getLogger();
        Log.LogLevel currentLogLevel = log.getLogLevel();
        if (logLevel.getPriority() >= currentLogLevel.getPriority()) {
            log.printLog(logLevel, tag, message);
        }
    }

    public void printAndPromptLog(Log.LogLevel logLevel, String tag, String message) {
        this.getLogger().printAndPromptLog(logLevel, tag, message);
    }

    ILeveledLogOutput getLogger() {
        ILeveledLogOutput log = this.mLogTable.get(this.getCurrentThreadGroup());
        if (log == null) {
            log = this.mGlobalLogger;
        }
        return log;
    }

    @Override
    public void closeAndRemoveAllLogs() {
        Collection<ILeveledLogOutput> allLogs = this.mLogTable.values();
        Iterator<ILeveledLogOutput> iter = allLogs.iterator();
        while (iter.hasNext()) {
            ILeveledLogOutput log = iter.next();
            log.closeLog();
            iter.remove();
        }
        this.saveGlobalLog();
        this.mGlobalLogger.closeLog();
    }

    @Override
    public void saveGlobalLog() {
        InputStreamSource globalLog = this.mGlobalLogger.getLog();
        this.saveLog("tradefed_global_log_", globalLog);
        globalLog.cancel();
    }

    private void saveLog(String filePrefix, InputStreamSource logData) {
        try {
            File tradefedLog = FileUtil.createTempFile(filePrefix, ".txt");
            FileUtil.writeToFile(logData.createInputStream(), tradefedLog);
            System.out.println(String.format("Saved log to %s", tradefedLog.getAbsolutePath()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void dumpLogs() {
        for (Map.Entry<ThreadGroup, ILeveledLogOutput> logEntry : this.mLogTable.entrySet()) {
            String filePrefix = String.format("%s_log_", logEntry.getKey().getName());
            InputStreamSource logSource = logEntry.getValue().getLog();
            this.saveLog(filePrefix, logSource);
            logSource.cancel();
        }
        this.saveGlobalLog();
    }
}

