/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.IDevice;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ILogFileSaver;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.LogFileSaver;
import com.android.tradefed.result.RetentionFileSaver;
import com.android.tradefed.result.StubTestInvocationListener;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipFile;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@OptionClass(alias="code-coverage-reporter")
public class CodeCoverageReporter
extends StubTestInvocationListener {
    @Option(name="coverage-metadata-file-path", description="The path of the Emma coverage meta data file used to generate the report.")
    private String mCoverageMetaFilePath = null;
    @Option(name="coverage-output-path", description="The location where to store the html coverage reports.", mandatory=true)
    private String mReportRootPath = null;
    @Option(name="coverage-metadata-label", description="The label of the Emma coverage meta data zip file inside the IBuildInfo.")
    private String mCoverageMetaZipFileName = "emma_meta.zip";
    @Option(name="log-retention-days", description="The number of days to keep generated coverage files")
    private Integer mLogRetentionDays = null;
    private static int REPORT_GENERATION_TIMEOUT_MS = 180000;
    public static String XML_REPORT_NAME = "report.xml";
    private IBuildInfo mBuildInfo;
    private ILogFileSaver mLogFileSaver;
    private File mLocalTmpDir = null;
    private List<File> mCoverageFilesList = new ArrayList<File>();
    private File mCoverageMetaFile = null;
    private File mXMLReportFile = null;
    private File mReportOutputPath = null;

    public void setMetaZipFilePath(String filePath) {
        this.mCoverageMetaFilePath = filePath;
    }

    public void setReportRootPath(String rootPath) {
        this.mReportRootPath = rootPath;
    }

    public void setMetaZipFileName(String filename) {
        this.mCoverageMetaZipFileName = filename;
    }

    public void setLogRetentionDays(Integer logRetentionDays) {
        this.mLogRetentionDays = logRetentionDays;
    }

    @Override
    public void testLog(String dataName, LogDataType dataType, InputStreamSource dataStream) {
        if (LogDataType.COVERAGE.equals((Object)dataType)) {
            File coverageFile = this.saveLogAsFile(dataName, dataType, dataStream);
            this.mCoverageFilesList.add(coverageFile);
            LogUtil.CLog.d("Saved a new device coverage file saved at %s", coverageFile.getAbsolutePath());
        }
    }

    private File saveLogAsFile(String dataName, LogDataType dataType, InputStreamSource dataStream) {
        try {
            File logFile = this.mLogFileSaver.saveLogData(dataName, dataType, dataStream.createInputStream());
            return logFile;
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
            return null;
        }
    }

    public File getXMLReportFile() {
        return this.mXMLReportFile;
    }

    public File getReportOutputPath() {
        return this.mReportOutputPath;
    }

    public File getHTMLReportFile() {
        return new File(this.mReportOutputPath, "index.html");
    }

    @Override
    public void invocationStarted(IBuildInfo buildInfo) {
        this.mBuildInfo = buildInfo;
        this.mReportOutputPath = this.generateReportLocation(this.mReportRootPath);
        LogUtil.CLog.d("ReportOutputPath: %s", this.mReportOutputPath);
        this.mXMLReportFile = new File(this.mReportOutputPath, XML_REPORT_NAME);
        LogUtil.CLog.d("ReportOutputPath: %s", this.mXMLReportFile);
        this.mLogFileSaver = new LogFileSaver(this.mReportOutputPath);
        LogUtil.CLog.d("ReportOutputPath %s", this.mReportOutputPath.getAbsolutePath());
        LogUtil.CLog.d("LogfileSaver file dir %s", this.mLogFileSaver.getFileDir().getAbsolutePath());
    }

    @Override
    public void invocationEnded(long elapsedTime) {
        this.generateReport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateReport() {
        block9: {
            LogUtil.CLog.d("Generating report for code coverage");
            try {
                this.fetchAppropriateMetaDataFile();
                if (!this.mCoverageFilesList.isEmpty()) {
                    this.generateCoverageReport(this.mCoverageFilesList, this.mCoverageMetaFile);
                } else {
                    LogUtil.CLog.w("No coverage files were generated by the test. Perhaps test failed to run successfully.");
                }
                Object var2_1 = null;
                if (this.mCoverageFilesList.isEmpty()) break block9;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (!this.mCoverageFilesList.isEmpty()) {
                    for (File coverageFile : this.mCoverageFilesList) {
                        FileUtil.recursiveDelete(coverageFile);
                    }
                }
                if (this.mLocalTmpDir != null) {
                    FileUtil.recursiveDelete(this.mLocalTmpDir);
                }
                throw throwable;
            }
            for (File coverageFile : this.mCoverageFilesList) {
                FileUtil.recursiveDelete(coverageFile);
            }
        }
        if (this.mLocalTmpDir != null) {
            FileUtil.recursiveDelete(this.mLocalTmpDir);
        }
    }

    private void fetchAppropriateMetaDataFile() {
        File coverageZipFile = this.mBuildInfo.getFile(this.mCoverageMetaZipFileName);
        Assert.assertNotNull("Failed to get the coverage metadata zipfile from the build.", coverageZipFile);
        LogUtil.CLog.d("Coverage zip file: %s", coverageZipFile.getAbsolutePath());
        try {
            this.mLocalTmpDir = FileUtil.createTempDir("emma-meta");
            ZipFile zipFile = new ZipFile(coverageZipFile);
            FileUtil.extractZip(zipFile, this.mLocalTmpDir);
            File coverageMetaFile = this.mCoverageMetaFilePath == null ? FileUtil.findFile(this.mLocalTmpDir, "coverage.em") : new File(this.mLocalTmpDir, this.mCoverageMetaFilePath);
            if (coverageMetaFile.exists()) {
                this.mCoverageMetaFile = coverageMetaFile;
                LogUtil.CLog.d("Coverage meta data file %s", this.mCoverageMetaFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
        }
    }

    private File generateReportLocation(String rootPath) {
        String branchName = this.mBuildInfo.getBuildBranch();
        String buildId = this.mBuildInfo.getBuildId();
        File branchPath = new File(rootPath, branchName);
        File buildIdPath = new File(branchPath, buildId);
        FileUtil.mkdirsRWX(buildIdPath);
        if (this.mLogRetentionDays != null) {
            RetentionFileSaver f = new RetentionFileSaver();
            f.writeRetentionFile(buildIdPath, this.mLogRetentionDays);
        }
        return buildIdPath;
    }

    private void generateCoverageReport(List<File> coverageFileList, File metaFile) {
        Assert.assertFalse("Could not find a valid coverage file.", coverageFileList.isEmpty());
        Assert.assertNotNull("Could not find a valid meta data coverage file.", metaFile);
        String emmaPath = this.findEmmaJarPath();
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.addAll(Arrays.asList("java", "-cp", emmaPath, "emma", "report", "-r", "html", "-r", "xml", "-in", metaFile.getAbsolutePath(), "-Dreport.html.out.encoding=UTF-8", "-Dreport.html.out.file=" + this.mReportOutputPath.getAbsolutePath() + "/index.html", "-Dreport.xml.out.file=" + this.mReportOutputPath.getAbsolutePath() + "/report.xml"));
        for (File coverageFile : coverageFileList) {
            cmdList.add("-in");
            cmdList.add(coverageFile.getAbsolutePath());
        }
        String[] cmd = cmdList.toArray(new String[cmdList.size()]);
        IRunUtil runUtil = RunUtil.getDefault();
        CommandResult result = runUtil.runTimedCmd(REPORT_GENERATION_TIMEOUT_MS, cmd);
        if (!result.getStatus().equals((Object)CommandStatus.SUCCESS)) {
            LogUtil.CLog.e("Failed to generate coverage report. stderr: %s", result.getStderr());
        } else {
            boolean setPerms = FileUtil.chmodRWXRecursively(this.mReportOutputPath);
            if (!setPerms) {
                LogUtil.CLog.w("Failed to set %s to be world accessible.", this.mReportOutputPath.getAbsolutePath());
            }
        }
    }

    String findEmmaJarPath() {
        String ddmlibPath = IDevice.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        Assert.assertFalse("failed to find ddmlib path", ddmlibPath.isEmpty());
        File parentFolder = new File(ddmlibPath);
        File emmaJar = new File(parentFolder.getParent(), "emmalib.jar");
        Assert.assertTrue(String.format("Failed to find emma.jar in %s", emmaJar.getAbsolutePath()), emmaJar.exists());
        LogUtil.CLog.d("Found emma jar at %s", emmaJar.getAbsolutePath());
        return emmaJar.getAbsolutePath();
    }
}

