/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestResult;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.result.TestSummary;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectingTestListener
implements ITestInvocationListener {
    private Map<String, TestRunResult> mRunResultsMap = Collections.synchronizedMap(new LinkedHashMap());
    private TestRunResult mCurrentResults = new TestRunResult();
    @Option(name="aggregate-metrics", description="attempt to add test metrics values for test runs with the same name.")
    private boolean mIsAggregateMetrics = false;
    private IBuildInfo mBuildInfo;

    void setIsAggregrateMetrics(boolean aggregate) {
        this.mIsAggregateMetrics = aggregate;
    }

    @Override
    public void invocationStarted(IBuildInfo buildInfo) {
        this.mBuildInfo = buildInfo;
    }

    public IBuildInfo getBuildInfo() {
        return this.mBuildInfo;
    }

    public void setBuildInfo(IBuildInfo buildInfo) {
        this.mBuildInfo = buildInfo;
    }

    public void testRunStarted(String name, int numTests) {
        if (this.mRunResultsMap.containsKey(name)) {
            this.mCurrentResults = this.mRunResultsMap.get(name);
        } else {
            this.mCurrentResults = new TestRunResult(name);
            this.mRunResultsMap.put(name, this.mCurrentResults);
        }
        this.mCurrentResults.setRunComplete(false);
        this.mCurrentResults.setRunFailureError(null);
    }

    public void testStarted(TestIdentifier test) {
        this.mCurrentResults.reportTestStarted(test);
    }

    public void testEnded(TestIdentifier test, Map<String, String> testMetrics) {
        this.mCurrentResults.reportTestEnded(test, testMetrics);
    }

    public void testFailed(ITestRunListener.TestFailure testFailure, TestIdentifier test, String trace) {
        if (testFailure.equals((Object)ITestRunListener.TestFailure.ERROR)) {
            this.mCurrentResults.reportTestFailure(test, TestResult.TestStatus.ERROR, trace);
        } else {
            this.mCurrentResults.reportTestFailure(test, TestResult.TestStatus.FAILURE, trace);
        }
    }

    public void testRunEnded(long elapsedTime, Map<String, String> runMetrics) {
        this.mCurrentResults.setRunComplete(true);
        this.mCurrentResults.addMetrics(runMetrics, this.mIsAggregateMetrics);
        this.mCurrentResults.addElapsedTime(elapsedTime);
    }

    public void testRunFailed(String errorMessage) {
        this.mCurrentResults.setRunFailureError(errorMessage);
    }

    public void testRunStopped(long elapsedTime) {
        this.mCurrentResults.setRunComplete(true);
        this.mCurrentResults.addElapsedTime(elapsedTime);
    }

    public TestRunResult getCurrentRunResults() {
        return this.mCurrentResults;
    }

    public Collection<TestRunResult> getRunResults() {
        return this.mRunResultsMap.values();
    }

    public int getNumTotalTests() {
        return this.getNumFailedTests() + this.getNumErrorTests() + this.getNumPassedTests();
    }

    public int getNumFailedTests() {
        int numFailedTests = 0;
        for (TestRunResult result : this.mRunResultsMap.values()) {
            numFailedTests += result.getNumFailedTests();
        }
        return numFailedTests;
    }

    public int getNumErrorTests() {
        int numErrorTests = 0;
        for (TestRunResult result : this.mRunResultsMap.values()) {
            numErrorTests += result.getNumErrorTests();
        }
        return numErrorTests;
    }

    public int getNumPassedTests() {
        int numPassedTests = 0;
        for (TestRunResult result : this.mRunResultsMap.values()) {
            numPassedTests += result.getNumPassedTests();
        }
        return numPassedTests;
    }

    public int getNumIncompleteTests() {
        int numIncompleteTests = 0;
        for (TestRunResult result : this.mRunResultsMap.values()) {
            numIncompleteTests += result.getNumIncompleteTests();
        }
        return numIncompleteTests;
    }

    public boolean hasFailedTests() {
        return this.getNumErrorTests() > 0 || this.getNumFailedTests() > 0;
    }

    @Override
    public void invocationEnded(long elapsedTime) {
    }

    @Override
    public void invocationFailed(Throwable cause) {
    }

    @Override
    public TestSummary getSummary() {
        return null;
    }

    @Override
    public void testLog(String dataName, LogDataType dataType, InputStreamSource dataStream) {
    }
}

