/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.SnapshotInputStreamSource;
import com.android.tradefed.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceFileReporter {
    private final Map<String, LogDataType> mFilePatterns = new LinkedHashMap<String, LogDataType>();
    private final ITestInvocationListener mListener;
    private final ITestDevice mDevice;
    private LogDataType mDefaultFileType = LogDataType.UNKNOWN;

    public DeviceFileReporter(ITestDevice device, ITestInvocationListener listener) {
        if (device == null || listener == null) {
            throw new NullPointerException();
        }
        this.mDevice = device;
        this.mListener = listener;
    }

    public void addPatterns(String ... patterns) {
        this.addPatterns(Arrays.asList(patterns));
    }

    public void addPatterns(List<String> patterns) {
        for (String pat : patterns) {
            this.mFilePatterns.put(pat, this.mDefaultFileType);
        }
    }

    public void addPatterns(Map<String, LogDataType> patterns) {
        this.mFilePatterns.putAll(patterns);
    }

    public void setDefaultLogDataType(LogDataType type) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.mDefaultFileType = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> run() throws DeviceNotAvailableException {
        LinkedList<String> filenames = new LinkedList<String>();
        Iterator<Map.Entry<String, LogDataType>> i$ = this.mFilePatterns.entrySet().iterator();
        block4: while (i$.hasNext()) {
            Map.Entry<String, LogDataType> pat = i$.next();
            String searchCmd = String.format("ls '%s'", pat.getKey());
            String fileList = this.mDevice.executeShellCommand(searchCmd);
            String[] arr$ = fileList.split("\r\n");
            int len$ = arr$.length;
            int i$2 = 0;
            while (true) {
                block11: {
                    if (i$2 >= len$) continue block4;
                    String filename = arr$[i$2];
                    if (!filename.isEmpty() && !filename.endsWith(": No such file or directory")) {
                        Object var14_13;
                        File file = null;
                        InputStreamSource iss = null;
                        try {
                            try {
                                LogUtil.CLog.v("Trying to pull file %s from device %s", filename, this.mDevice.getSerialNumber());
                                file = this.mDevice.pullFile(filename);
                                LogUtil.CLog.v("Local file %s has size %d", file, file.length());
                                iss = this.createIssForFile(file);
                                this.mListener.testLog(filename, pat.getValue(), iss);
                                filenames.add(filename);
                            }
                            catch (IOException e) {
                                LogUtil.CLog.w("Failed to log file %s: %s", filename, e.getMessage());
                                var14_13 = null;
                                if (iss != null) {
                                    iss.cancel();
                                    iss = null;
                                }
                                FileUtil.deleteFile(file);
                                break block11;
                            }
                            var14_13 = null;
                            if (iss != null) {
                                iss.cancel();
                                iss = null;
                            }
                        }
                        catch (Throwable throwable) {
                            var14_13 = null;
                            if (iss != null) {
                                iss.cancel();
                                iss = null;
                            }
                            FileUtil.deleteFile(file);
                            throw throwable;
                        }
                        FileUtil.deleteFile(file);
                    }
                }
                ++i$2;
            }
            break;
        }
        return filenames;
    }

    InputStreamSource createIssForFile(File file) throws IOException {
        BufferedInputStream bufStr = new BufferedInputStream(new FileInputStream(file));
        return new SnapshotInputStreamSource(bufStr);
    }
}

