/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.tradefed.result.InputStreamSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileInputStreamSource
implements InputStreamSource {
    private final File mFile;
    private boolean mIsCancelled = false;

    public FileInputStreamSource(File file) {
        this.mFile = file;
    }

    public synchronized InputStream createInputStream() {
        if (this.mIsCancelled) {
            return null;
        }
        try {
            return new FileInputStream(this.mFile);
        }
        catch (IOException e) {
            return null;
        }
    }

    public synchronized void cancel() {
        this.mIsCancelled = true;
    }

    public long size() {
        return this.mFile.length();
    }
}

