/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestSummary;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Map;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationToJUnitResultForwarder
implements ITestInvocationListener {
    private static final String LOG_TAG = "InvocationToJUnitResultForwarder";
    private TestListener mJUnitListener;

    public InvocationToJUnitResultForwarder(TestListener junitListener) {
        this.mJUnitListener = junitListener;
    }

    protected TestListener getJUnitListener() {
        return this.mJUnitListener;
    }

    public void testEnded(TestIdentifier test, Map<String, String> testMetrics) {
        this.mJUnitListener.endTest(new TestIdentifierResult(test));
    }

    public void testFailed(ITestRunListener.TestFailure status, TestIdentifier testId, String trace) {
        TestIdentifierResult test = new TestIdentifierResult(testId);
        if (ITestRunListener.TestFailure.ERROR.equals((Object)status)) {
            RemoteException throwable = new RemoteException(trace);
            this.mJUnitListener.addError(test, throwable);
        } else {
            this.mJUnitListener.addFailure(test, new AssertionFailedError(trace));
        }
    }

    public void testRunEnded(long elapsedTime, Map<String, String> runMetrics) {
        Log.i((String)LOG_TAG, (String)String.format("run ended %d ms", elapsedTime));
    }

    public void testRunFailed(String errorMessage) {
        Log.e((String)LOG_TAG, (String)String.format("run failed: %s", errorMessage));
    }

    public void testRunStarted(String runName, int testCount) {
        Log.i((String)LOG_TAG, (String)String.format("run %s started: %d tests", runName, testCount));
    }

    public void testRunStopped(long elapsedTime) {
        Log.i((String)LOG_TAG, (String)String.format("run stopped: %d ms", elapsedTime));
    }

    public void testStarted(TestIdentifier test) {
        Log.d((String)LOG_TAG, (String)test.toString());
        this.mJUnitListener.startTest(new TestIdentifierResult(test));
    }

    @Override
    public void invocationEnded(long elapsedTime) {
    }

    @Override
    public void invocationFailed(Throwable cause) {
    }

    @Override
    public TestSummary getSummary() {
        return null;
    }

    @Override
    public void invocationStarted(IBuildInfo buildInfo) {
    }

    @Override
    public void testLog(String dataName, LogDataType logData, InputStreamSource dataStream) {
    }

    private static class RemoteException
    extends Throwable {
        private static final long serialVersionUID = 8510440697482917390L;
        private final String mStackTrace;

        RemoteException(String stack) {
            this.mStackTrace = stack;
        }

        public void printStackTrace() {
            System.err.print(this.mStackTrace);
        }

        public void printStackTrace(PrintStream s) {
            s.print(this.mStackTrace);
        }

        public void printStackTrace(PrintWriter s) {
            s.print(this.mStackTrace);
        }

        public void setStackTrace(StackTraceElement[] stackTrace) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.mStackTrace;
        }

        public Throwable fillInStackTrace() {
            return this;
        }
    }

    static class TestIdentifierResult
    implements Test {
        private final TestIdentifier mTestId;

        private TestIdentifierResult(TestIdentifier testId) {
            this.mTestId = testId;
        }

        public int countTestCases() {
            return 1;
        }

        public void run(TestResult result) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object other) {
            return this.mTestId.equals(other);
        }

        public int hashCode() {
            return this.mTestId.hashCode();
        }

        public String toString() {
            return String.format("%s:%s", this.mTestId.getClassName(), this.mTestId.getTestName());
        }
    }
}

