/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.InvocationSummaryHelper;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestSummary;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultForwarder
implements ITestInvocationListener {
    private List<ITestInvocationListener> mListeners;

    protected ResultForwarder() {
        this.mListeners = Collections.emptyList();
    }

    public ResultForwarder(List<ITestInvocationListener> listeners) {
        this.mListeners = listeners;
    }

    public ResultForwarder(ITestInvocationListener ... listeners) {
        this.mListeners = Arrays.asList(listeners);
    }

    protected void setListeners(List<ITestInvocationListener> listeners) {
        this.mListeners = listeners;
    }

    protected void setListeners(ITestInvocationListener ... listeners) {
        this.mListeners = Arrays.asList(listeners);
    }

    @Override
    public void invocationStarted(IBuildInfo buildInfo) {
        for (ITestInvocationListener listener : this.mListeners) {
            listener.invocationStarted(buildInfo);
        }
    }

    @Override
    public void invocationFailed(Throwable cause) {
        for (ITestInvocationListener listener : this.mListeners) {
            listener.invocationFailed(cause);
        }
    }

    @Override
    public void invocationEnded(long elapsedTime) {
        InvocationSummaryHelper.reportInvocationEnded(this.mListeners, elapsedTime);
    }

    @Override
    public TestSummary getSummary() {
        return null;
    }

    @Override
    public void testLog(String dataName, LogDataType dataType, InputStreamSource dataStream) {
        for (ITestInvocationListener listener : this.mListeners) {
            listener.testLog(dataName, dataType, dataStream);
        }
    }

    public void testRunStarted(String runName, int testCount) {
        for (ITestInvocationListener listener : this.mListeners) {
            listener.testRunStarted(runName, testCount);
        }
    }

    public void testRunFailed(String errorMessage) {
        for (ITestInvocationListener listener : this.mListeners) {
            listener.testRunFailed(errorMessage);
        }
    }

    public void testRunStopped(long elapsedTime) {
        for (ITestInvocationListener listener : this.mListeners) {
            listener.testRunStopped(elapsedTime);
        }
    }

    public void testRunEnded(long elapsedTime, Map<String, String> runMetrics) {
        for (ITestInvocationListener listener : this.mListeners) {
            listener.testRunEnded(elapsedTime, runMetrics);
        }
    }

    public void testStarted(TestIdentifier test) {
        for (ITestInvocationListener listener : this.mListeners) {
            listener.testStarted(test);
        }
    }

    public void testFailed(ITestRunListener.TestFailure status, TestIdentifier test, String trace) {
        for (ITestInvocationListener listener : this.mListeners) {
            listener.testFailed(status, test, trace);
        }
    }

    public void testEnded(TestIdentifier test, Map<String, String> testMetrics) {
        for (ITestInvocationListener listener : this.mListeners) {
            listener.testEnded(test, testMetrics);
        }
    }
}

