/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.ILogFileSaver;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.LogFileSaver;
import com.android.tradefed.result.TestResult;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.kxml2.io.KXmlSerializer;

@OptionClass(alias="xml")
public class XmlResultReporter
extends CollectingTestListener {
    private static final String LOG_TAG = "XmlResultReporter";
    private static final String TEST_RESULT_FILE_SUFFIX = ".xml";
    private static final String TEST_RESULT_FILE_PREFIX = "test_result_";
    private static final String TESTSUITE = "testsuite";
    private static final String TESTCASE = "testcase";
    private static final String ERROR = "error";
    private static final String FAILURE = "failure";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TIME = "time";
    private static final String ATTR_ERRORS = "errors";
    private static final String ATTR_FAILURES = "failures";
    private static final String ATTR_TESTS = "tests";
    private static final String PROPERTIES = "properties";
    private static final String ATTR_CLASSNAME = "classname";
    private static final String TIMESTAMP = "timestamp";
    private static final String HOSTNAME = "hostname";
    private static final String ns = null;
    private static final String REPORT_DIR_NAME = "output-file-path";
    @Option(name="output-file-path", description="root file system path to directory to store xml test results and associated logs.")
    private File mReportDir = new File(System.getProperty("java.io.tmpdir"));
    private ILogFileSaver mLogFileSaver;
    private IBuildInfo mBuildInfo;
    private String mReportPath = "";

    public void invocationEnded(long elapsedTime) {
        super.invocationEnded(elapsedTime);
        if (this.mReportDir != null) {
            this.generateSummary(this.mLogFileSaver.getFileDir(), elapsedTime);
        }
    }

    public void invocationStarted(IBuildInfo buildInfo) {
        super.invocationStarted(buildInfo);
        if (this.mReportDir == null) {
            throw new IllegalArgumentException(String.format("missing %s", REPORT_DIR_NAME));
        }
        this.mLogFileSaver = new LogFileSaver(buildInfo, this.mReportDir);
        this.mBuildInfo = buildInfo;
    }

    public void testFailed(ITestRunListener.TestFailure status, TestIdentifier test, String trace) {
        super.testFailed(status, test, trace);
        LogUtil.CLog.d("%s %s: %s", test, status, trace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateSummary(File reportDir, long elapsedTime) {
        String timestamp = this.getTimestamp();
        OutputStream stream = null;
        stream = this.createOutputResultStream(reportDir);
        KXmlSerializer serializer = new KXmlSerializer();
        serializer.setOutput(stream, "UTF-8");
        serializer.startDocument("UTF-8", null);
        serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        this.printTestResults(serializer, timestamp, elapsedTime);
        serializer.endDocument();
        String msg = String.format("XML test result file generated at %s. Total tests %d, Failed %d, Error %d", this.getAbsoluteReportPath(), this.getNumTotalTests(), this.getNumFailedTests(), this.getNumErrorTests());
        Log.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)LOG_TAG, (String)msg);
        Object var9_8 = null;
        if (stream == null) return;
        try {
            stream.close();
            return;
        }
        catch (IOException ignored) {}
        return;
        {
            catch (IOException e) {
                Log.e((String)LOG_TAG, (String)"Failed to generate report data");
                Object var9_9 = null;
                if (stream == null) return;
                try {
                    stream.close();
                    return;
                }
                catch (IOException ignored) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (stream == null) throw throwable;
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private String getAbsoluteReportPath() {
        return this.mReportPath;
    }

    String getTimestamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        TimeZone gmt = TimeZone.getTimeZone("UTC");
        dateFormat.setTimeZone(gmt);
        dateFormat.setLenient(true);
        String timestamp = dateFormat.format(new Date());
        return timestamp;
    }

    OutputStream createOutputResultStream(File reportDir) throws IOException {
        File reportFile = FileUtil.createTempFile(TEST_RESULT_FILE_PREFIX, TEST_RESULT_FILE_SUFFIX, reportDir);
        Log.i((String)LOG_TAG, (String)String.format("Created xml report file at %s", reportFile.getAbsolutePath()));
        this.mReportPath = reportFile.getAbsolutePath();
        return new FileOutputStream(reportFile);
    }

    void printTestResults(KXmlSerializer serializer, String timestamp, long elapsedTime) throws IOException {
        serializer.startTag(ns, TESTSUITE);
        serializer.attribute(ns, ATTR_NAME, this.mBuildInfo.getTestTag());
        serializer.attribute(ns, ATTR_TESTS, Integer.toString(this.getNumTotalTests()));
        serializer.attribute(ns, ATTR_FAILURES, Integer.toString(this.getNumFailedTests()));
        serializer.attribute(ns, ATTR_ERRORS, Integer.toString(this.getNumErrorTests()));
        serializer.attribute(ns, ATTR_TIME, Long.toString(elapsedTime));
        serializer.attribute(ns, TIMESTAMP, timestamp);
        serializer.attribute(ns, HOSTNAME, "localhost");
        serializer.startTag(ns, PROPERTIES);
        serializer.endTag(ns, PROPERTIES);
        for (TestRunResult runResult : this.getRunResults()) {
            Map<TestIdentifier, TestResult> testResults = runResult.getTestResults();
            for (Map.Entry<TestIdentifier, TestResult> testEntry : testResults.entrySet()) {
                this.print(serializer, testEntry.getKey(), testEntry.getValue());
            }
        }
        serializer.endTag(ns, TESTSUITE);
    }

    void print(KXmlSerializer serializer, TestIdentifier testId, TestResult testResult) throws IOException {
        serializer.startTag(ns, TESTCASE);
        serializer.attribute(ns, ATTR_NAME, testId.getTestName());
        serializer.attribute(ns, ATTR_CLASSNAME, testId.getClassName());
        serializer.attribute(ns, ATTR_TIME, "0");
        if (!TestResult.TestStatus.PASSED.equals((Object)testResult.getStatus())) {
            String result = testResult.getStatus().equals((Object)TestResult.TestStatus.FAILURE) ? FAILURE : ERROR;
            serializer.startTag(ns, result);
            String stackText = this.sanitize(testResult.getStackTrace());
            serializer.text(stackText);
            serializer.endTag(ns, result);
        }
        serializer.endTag(ns, TESTCASE);
    }

    private String sanitize(String text) {
        return text.replace("\u0000", "<\\0>");
    }

    void setReportDir(File file) {
        this.mReportDir = file;
    }

    public void testLog(String dataName, LogDataType dataType, InputStreamSource dataStream) {
        try {
            File logFile = this.mLogFileSaver.saveLogData(dataName, dataType, dataStream.createInputStream());
            Log.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)LOG_TAG, (String)String.format("Saved %s log to %s", dataName, logFile.getAbsolutePath()));
        }
        catch (IOException e) {
            Log.e((String)LOG_TAG, (String)"Failed to save log data");
            Log.e((String)LOG_TAG, (Throwable)e);
        }
    }
}

