/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.build.IAppBuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.VersionedFile;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.ITargetCleaner;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@OptionClass(alias="app-setup")
public class AppSetup
implements ITargetPreparer,
ITargetCleaner {
    @Option(name="reboot", description="reboot device after running tests.")
    private boolean mReboot = true;
    @Option(name="install", description="install all apks in build.")
    private boolean mInstall = true;
    @Option(name="uninstall", description="uninstall all apks after test completes.")
    private boolean mUninstall = true;
    @Option(name="skip-uninstall-pkg", description="force retention of this package when --uninstall is set.")
    private Set<String> mSkipUninstallPkgs = new HashSet<String>();

    @Override
    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, DeviceNotAvailableException {
        if (!(buildInfo instanceof IAppBuildInfo)) {
            throw new IllegalArgumentException("Provided buildInfo is not a AppBuildInfo");
        }
        IAppBuildInfo appBuild = (IAppBuildInfo)buildInfo;
        LogUtil.CLog.i("Performing setup on %s", device.getSerialNumber());
        if (this.mUninstall && !this.uninstallApps(device)) {
            throw new DeviceNotAvailableException(String.format("Failed to uninstall apps on %s", device.getSerialNumber()));
        }
        if (this.mInstall) {
            for (VersionedFile apkFile : appBuild.getAppPackageFiles()) {
                String result = device.installPackage(apkFile.getFile(), true, new String[0]);
                if (result == null) continue;
                throw new TargetSetupError(String.format("Failed to install %s on %s. Reason: %s", apkFile.getFile().getName(), device.getSerialNumber(), result));
            }
        }
    }

    @Override
    public void tearDown(ITestDevice device, IBuildInfo buildInfo, Throwable e) throws DeviceNotAvailableException {
        if (this.mReboot) {
            device.reboot();
        }
        if (this.mUninstall && !this.uninstallApps(device)) {
            throw new DeviceNotAvailableException(String.format("Failed to uninstall apps on %s", device.getSerialNumber()));
        }
    }

    private boolean uninstallApps(ITestDevice device) throws DeviceNotAvailableException {
        for (int i = 0; i < 3; ++i) {
            Set<String> pkgs = this.getAppsToUninstall(device);
            if (pkgs.isEmpty()) {
                return true;
            }
            for (String pkg : pkgs) {
                String result = device.uninstallPackage(pkg);
                if (result == null) continue;
                LogUtil.CLog.w("Uninstall of %s on %s failed: %s", pkg, device.getSerialNumber(), result);
            }
        }
        return this.getAppsToUninstall(device).isEmpty();
    }

    private Set<String> getAppsToUninstall(ITestDevice device) throws DeviceNotAvailableException {
        Set<String> pkgs = device.getUninstallablePackageNames();
        pkgs.removeAll(this.mSkipUninstallPkgs);
        return pkgs;
    }
}

