/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.ddmlib.Log;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.targetprep.FastbootDeviceFlasher;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;

public class CdmaDeviceFlasher
extends FastbootDeviceFlasher {
    private static final String LOG_TAG = "CdmaDeviceFlasher";
    private boolean mShouldFlashBaseband = false;
    protected static final int BASEBAND_FLASH_TIMEOUT = 600000;

    protected String getBootPartitionName() {
        return "bootloader";
    }

    public void flash(ITestDevice device, IDeviceBuildInfo deviceBuild) throws TargetSetupError, DeviceNotAvailableException {
        Log.i((String)LOG_TAG, (String)String.format("Flashing device %s with build %s", device.getSerialNumber(), deviceBuild.getBuildId()));
        String systemBuildId = device.getBuildId();
        device.rebootIntoBootloader();
        this.downloadFlashingResources(device, deviceBuild);
        this.checkAndFlashBootloader(device, deviceBuild);
        if (this.checkShouldFlashBaseband(device, deviceBuild)) {
            Log.i((String)LOG_TAG, (String)"Performing special CDMA baseband update flash procedure");
            this.flashUserData(device, deviceBuild);
            this.wipeCache(device);
            this.mShouldFlashBaseband = true;
            this.checkAndFlashBaseband(device, deviceBuild);
            this.checkAndFlashSystem(device, systemBuildId, deviceBuild);
            device.reboot();
        } else {
            this.flashUserData(device, deviceBuild);
            this.wipeCache(device);
            this.checkAndFlashSystem(device, systemBuildId, deviceBuild);
            device.reboot();
        }
    }

    protected void flashBaseband(ITestDevice device, File basebandImageFile) throws DeviceNotAvailableException, TargetSetupError {
        this.executeLongFastbootCmd(device, "flash", "radio", basebandImageFile.getAbsolutePath());
    }

    private void flashNamedPartition(ITestDevice device, File dir, String partition) throws DeviceNotAvailableException, TargetSetupError {
        File imgFile = new File(dir, partition + ".img");
        this.flashPartition(device, imgFile, partition);
    }

    protected File extractSystemZip(IDeviceBuildInfo deviceBuild) throws IOException {
        File updateDir = FileUtil.createTempDir(LOG_TAG);
        ZipFile updater = new ZipFile(deviceBuild.getDeviceImageFile().getAbsolutePath());
        FileUtil.extractZip(updater, updateDir);
        return updateDir;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void flashSystem(ITestDevice device, IDeviceBuildInfo deviceBuild) throws DeviceNotAvailableException, TargetSetupError {
        block5: {
            if (!this.mShouldFlashBaseband) {
                super.flashSystem(device, deviceBuild);
                device.waitForDeviceOnline();
                device.rebootIntoBootloader();
                return;
            }
            Log.i((String)LOG_TAG, (String)String.format("MANUALLY flashing individual partitions on %s.", device.getSerialNumber()));
            File updateDir = null;
            try {
                try {
                    updateDir = this.extractSystemZip(deviceBuild);
                    this.flashNamedPartition(device, updateDir, "boot");
                    this.flashNamedPartition(device, updateDir, "recovery");
                    this.flashNamedPartition(device, updateDir, "system");
                }
                catch (IOException e) {
                    throw new TargetSetupError(String.format("Got IOException: %s", e.getMessage()));
                }
                Object var6_4 = null;
                if (updateDir == null) break block5;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                if (updateDir == null) throw throwable;
                FileUtil.recursiveDelete(updateDir);
                updateDir = null;
                throw throwable;
            }
            FileUtil.recursiveDelete(updateDir);
            updateDir = null;
        }
        device.executeFastbootCommand("reboot");
        device.waitForDeviceOnline(600000L);
        device.waitForDeviceAvailable();
        this.getRunUtil().sleep(5000L);
        device.reboot();
        this.getRunUtil().sleep(5000L);
        device.rebootIntoBootloader();
    }

    protected IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }
}

