/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.IFileEntry;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.ITestsZipInstaller;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.ArrayUtil;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTestsZipInstaller
implements ITestsZipInstaller {
    private static final int RM_ATTEMPTS = 3;
    private static final String DEVICE_DATA_PATH = DefaultTestsZipInstaller.buildAbsPath("data");
    private static final File DEVICE_DATA_FILE = new File(DEVICE_DATA_PATH);
    private Set<String> mDataWipeSkipList;

    public DefaultTestsZipInstaller(String ... skipList) {
        this.setDataWipeSkipList(skipList);
    }

    @Override
    public void setDataWipeSkipList(String ... skipList) {
        this.mDataWipeSkipList = new HashSet<String>(skipList.length);
        this.mDataWipeSkipList.addAll(Arrays.asList(skipList));
    }

    @Override
    public void pushTestsZipOntoData(ITestDevice device, IDeviceBuildInfo deviceBuild) throws DeviceNotAvailableException, TargetSetupError {
        File[] hostDataFiles;
        LogUtil.CLog.i(String.format("Pushing test zips content onto userdata on %s", device.getSerialNumber()));
        ITestDevice.RecoveryMode cachedRecoveryMode = device.getRecoveryMode();
        device.setRecoveryMode(ITestDevice.RecoveryMode.ONLINE);
        this.doDeleteData(device);
        LogUtil.CLog.d("Syncing test files/apks");
        File hostDir = new File(deviceBuild.getTestsDir(), "DATA");
        for (File hostSubDir : hostDataFiles = this.getTestsZipDataFiles(hostDir)) {
            device.syncFiles(hostSubDir, DEVICE_DATA_PATH);
        }
        for (File dir : this.findDirs(hostDir, DEVICE_DATA_FILE)) {
            device.executeShellCommand("chown system.system " + dir.getPath());
        }
        device.setRecoveryMode(cachedRecoveryMode);
    }

    @Override
    public void deleteData(ITestDevice device) throws DeviceNotAvailableException, TargetSetupError {
        ITestDevice.RecoveryMode cachedRecoveryMode = device.getRecoveryMode();
        device.setRecoveryMode(ITestDevice.RecoveryMode.ONLINE);
        this.doDeleteData(device);
        device.setRecoveryMode(cachedRecoveryMode);
    }

    private void doDeleteData(ITestDevice device) throws DeviceNotAvailableException, TargetSetupError {
        device.executeShellCommand("stop");
        device.executeShellCommand("stop installd");
        LogUtil.CLog.d("clearing data directory on device " + device.getSerialNumber());
        String turtlePath = DefaultTestsZipInstaller.buildRelPath(DEVICE_DATA_PATH, String.format("turtles-%d.txt", System.currentTimeMillis()));
        boolean yayTurtle = device.pushString("I like turtles", turtlePath);
        if (!yayTurtle) {
            throw new TargetSetupError(String.format("Failed userdata write check on device %s", device.getSerialNumber()));
        }
        IFileEntry dataEntry = device.getFileEntry("data");
        if (dataEntry == null) {
            throw new TargetSetupError(String.format("Could not find %s folder on %s", "data", device.getSerialNumber()));
        }
        for (IFileEntry dataSubDir : dataEntry.getChildren(false)) {
            if (this.mDataWipeSkipList.contains(dataSubDir.getName())) continue;
            this.deleteDir(device, dataSubDir.getFullEscapedPath());
        }
    }

    private void deleteDir(ITestDevice device, String fullEscapedPath) throws DeviceNotAvailableException, TargetSetupError {
        String result = "unknown";
        for (int i = 1; i <= 3; ++i) {
            result = device.executeShellCommand(String.format("rm -r %s", fullEscapedPath));
            if (!device.doesFileExist(fullEscapedPath)) {
                return;
            }
            LogUtil.CLog.d("Failed to delete dir %s on device %s on attempt %d of %d: stdout: %s", fullEscapedPath, device.getSerialNumber(), i, 3, result);
            this.getRunUtil().sleep(1000 * i * i);
        }
        throw new TargetSetupError(String.format("Failed to delete dir %s. rm output: %s", fullEscapedPath, result));
    }

    IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    private static String buildRelPath(String ... parts) {
        return ArrayUtil.join("/", parts);
    }

    private static String buildAbsPath(String ... parts) {
        return "/" + DefaultTestsZipInstaller.buildRelPath(parts);
    }

    File[] getTestsZipDataFiles(File hostDir) throws TargetSetupError {
        if (!hostDir.isDirectory()) {
            throw new TargetSetupError("Unrecognized tests.zip content: missing DATA folder");
        }
        File[] childFiles = hostDir.listFiles();
        if (childFiles == null || childFiles.length <= 0) {
            throw new TargetSetupError("Unrecognized tests.zip content: DATA folder has no content");
        }
        return childFiles;
    }

    Set<File> findDirs(File hostDir, File deviceRootPath) {
        return FileUtil.findDirsUnder(hostDir, deviceRootPath);
    }
}

