/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

@OptionClass(alias="install-apk-from-env")
public class InstallBuildEnvApkSetup
implements ITargetPreparer {
    @Option(name="apk-name", description="the file name of the apk to install. Can be repeated.", importance=Option.Importance.IF_UNSET)
    private Collection<String> mApkNames = new ArrayList<String>();

    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        File testAppDir = this.getDataAppDirFromBuildEnv();
        for (String apkName : this.mApkNames) {
            File apk = new File(testAppDir, apkName);
            LogUtil.CLog.i("Installing %s on %s", apk.getName(), device.getSerialNumber());
            String result = device.installPackage(apk, true, new String[0]);
            if (result == null) continue;
            throw new TargetSetupError(String.format("Failed to install %s on device %s. Reason: %s", apk.getAbsolutePath(), device.getSerialNumber(), result));
        }
    }

    private File getDataAppDirFromBuildEnv() throws TargetSetupError {
        String buildRoot = System.getenv("ANDROID_PRODUCT_OUT");
        if (buildRoot == null) {
            throw new TargetSetupError("ANDROID_PRODUCT_OUT is not set. Are you in Android build env?");
        }
        File testAppDir = new File(FileUtil.getPath(buildRoot, "data", "app"));
        if (!testAppDir.exists()) {
            throw new TargetSetupError(String.format("Could not find test app dir %s", testAppDir.getAbsolutePath()));
        }
        return testAppDir;
    }
}

