/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.KernelDeviceBuildInfo;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceUnresponsiveException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.io.File;
import java.io.IOException;

public class KernelFlashPreparer
implements ITargetPreparer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        if (!(buildInfo instanceof KernelDeviceBuildInfo)) {
            throw new IllegalArgumentException("Provided buildInfo is not a KernelDeviceBuildInfo");
        }
        KernelDeviceBuildInfo kernelBuildInfo = (KernelDeviceBuildInfo)buildInfo;
        LogUtil.CLog.i("Flashing device %s running %s with kernel %s", device.getSerialNumber(), device.getBuildId(), kernelBuildInfo.getSha1());
        if (kernelBuildInfo.getRamdiskFile() == null) {
            throw new TargetSetupError("Missing ramdisk file");
        }
        if (kernelBuildInfo.getMkbootimgFile() == null) {
            throw new TargetSetupError("Missing mkbootimg file");
        }
        if (kernelBuildInfo.getKernelFile() == null) {
            throw new TargetSetupError("Missing kernel file");
        }
        kernelBuildInfo.getMkbootimgFile().setExecutable(true);
        File boot = null;
        try {
            boot = this.createBootImage(kernelBuildInfo.getMkbootimgFile(), kernelBuildInfo.getKernelFile(), kernelBuildInfo.getRamdiskFile());
        }
        catch (IOException e) {
            throw new TargetSetupError("Could not create boot image", e);
        }
        try {
            device.rebootIntoBootloader();
            LogUtil.CLog.d("fastboot flash boot %s", boot.getAbsolutePath());
            device.executeFastbootCommand("flash", "boot", boot.getAbsolutePath());
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            FileUtil.deleteFile(boot);
            throw throwable;
        }
        FileUtil.deleteFile(boot);
        try {
            device.reboot();
        }
        catch (DeviceUnresponsiveException e) {
            throw new BuildError(String.format("Device %s did not become available after flashing kernel", device.getSerialNumber()));
        }
        device.postBootSetup();
    }

    File createBootImage(File mkbootimg, File kernel, File ramdisk) throws IOException {
        LogUtil.CLog.d("Create boot.img from %s and %s", kernel.getAbsolutePath(), ramdisk.getAbsolutePath());
        String bootPath = this.getBootImgPath();
        try {
            String[] cmd = new String[]{mkbootimg.getAbsolutePath(), "--kernel", kernel.getAbsolutePath(), "--ramdisk", ramdisk.getAbsolutePath(), "-o", bootPath};
            CommandResult result = this.getRunUtil().runTimedCmd(30000L, cmd);
            if (result.getStatus() != CommandStatus.SUCCESS) {
                LogUtil.CLog.e("mkbootimg failed. Command status was %s", new Object[]{result.getStatus()});
                FileUtil.deleteFile(new File(bootPath));
                throw new IOException();
            }
        }
        catch (IOException e) {
            FileUtil.deleteFile(new File(bootPath));
            throw e;
        }
        catch (RuntimeException e) {
            FileUtil.deleteFile(new File(bootPath));
            throw e;
        }
        return new File(bootPath);
    }

    IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    String getBootImgPath() throws IOException {
        File bootImg = FileUtil.createTempFile("boot", ".img");
        String bootImgPath = bootImg.getAbsolutePath();
        FileUtil.deleteFile(bootImg);
        return bootImgPath;
    }
}

