/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.ddmlib.Log;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@OptionClass(alias="push-file")
public class PushFilePreparer
implements ITargetPreparer {
    private static final String LOG_TAG = "PushFilePreparer";
    @Option(name="push", description="A push-spec, formatted as '/path/to/srcfile.txt->/path/to/destfile.txt' or '/path/to/srcfile.txt->/path/to/destdir/'. May be repeated.")
    private Collection<String> mPushSpecs = new LinkedList<String>();
    @Option(name="post-push", description="A command to run on the device (with `adb shell (yourcommand)`) after all pushes have been attempted.  Will not be run if a push fails with abort-on-push-failure enabled.  May be repeated.")
    private Collection<String> mPostPushCommands = new LinkedList<String>();
    @Option(name="abort-on-push-failure", description="If false, continue if pushes fail.  If true, abort the Invocation on any failure.")
    private boolean mAbortOnFailure = true;
    @Option(name="trigger-media-scan", description="After pushing files, trigger a media scan of external storage on device.")
    private boolean mTriggerMediaScan = false;

    void setAbortOnFailure(boolean value) {
        this.mAbortOnFailure = value;
    }

    void setPushSpecs(Collection<String> pushspecs) {
        this.mPushSpecs = pushspecs;
    }

    void setPostPushCommands(Collection<String> commands) {
        this.mPostPushCommands = commands;
    }

    private void fail(String message) throws TargetSetupError {
        if (this.mAbortOnFailure) {
            throw new TargetSetupError(message);
        }
        Log.w((String)LOG_TAG, (String)message);
    }

    @Override
    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        for (String pushspec : this.mPushSpecs) {
            String[] pair = pushspec.split("->");
            if (pair.length != 2) {
                this.fail(String.format("Invalid pushspec: '%s'", new Object[0]));
                continue;
            }
            Log.d((String)LOG_TAG, (String)String.format("Trying to push local '%s' to remote '%s'", pair[0], pair[1]));
            File src = new File(pair[0]);
            if (!(src.exists() || (src = buildInfo.getFile(pair[0])) != null && src.exists())) {
                this.fail(String.format("Local source file '%s' does not exist", pair[0]));
                continue;
            }
            if (src.isDirectory()) {
                if (device.pushDir(src, pair[1])) continue;
                this.fail(String.format("Failed to push local '%s' to remote '%s'", pair[0], pair[1]));
                continue;
            }
            if (device.pushFile(src, pair[1])) continue;
            this.fail(String.format("Failed to push local '%s' to remote '%s'", pair[0], pair[1]));
        }
        for (String command : this.mPostPushCommands) {
            device.executeShellCommand(command);
        }
        if (this.mTriggerMediaScan) {
            device.executeShellCommand(String.format("am broadcast -a android.intent.action.MEDIA_MOUNTED -d file://%s", device.getMountPoint("EXTERNAL_STORAGE")));
        }
    }
}

