/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.ITargetCleaner;
import com.android.tradefed.targetprep.TargetSetupError;
import java.util.ArrayList;
import java.util.List;

public class RunCommandTargetPreparer
implements ITargetCleaner {
    @Option(name="run-command", description="adb shell command to run")
    private List<String> mCommands = new ArrayList<String>();
    @Option(name="teardown-command", description="adb shell command to run at teardown time")
    private List<String> mTeardownCommands = new ArrayList<String>();

    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, DeviceNotAvailableException {
        for (String cmd : this.mCommands) {
            LogUtil.CLog.d("About to run setup command on device %s: %s", device.getSerialNumber(), cmd);
            device.executeShellCommand(cmd);
        }
    }

    public void tearDown(ITestDevice device, IBuildInfo buildInfo, Throwable e) throws DeviceNotAvailableException {
        for (String cmd : this.mTeardownCommands) {
            LogUtil.CLog.d("About to run tearDown command on device %s: %s", device.getSerialNumber(), cmd);
            device.executeShellCommand(cmd);
        }
    }
}

