/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.ISdkBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceManager;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.DeviceFailedToBootError;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.ArrayUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.util.List;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SdkAvdPreparer
implements ITargetPreparer {
    private static final int ANDROID_TIMEOUT_MS = 15000;
    @Option(name="sdk-target", description="the name of SDK target to launch. If unspecified, will use first target found")
    private String mTargetName = null;
    @Option(name="boot-time", description="the maximum time in minutes to wait for emulator to boot.")
    private long mMaxBootTime = 5L;
    @Option(name="window", description="launch emulator with a graphical window display.")
    private boolean mWindow = false;
    @Option(name="launch-attempts", description="max number of attempts to launch emulator")
    private int mLaunchAttempts = 1;
    @Option(name="sdcard-size", description="capacity of the SD card")
    private String mSdcardSize = "10M";
    @Option(name="gpu", description="launch emulator with GPU on")
    private boolean mGpu = false;
    @Option(name="abi", description="abi to select for the avd")
    private String mAbi = null;
    private final IRunUtil mRunUtil;
    private final IDeviceManager mDeviceManager;

    public SdkAvdPreparer() {
        this(new RunUtil(), DeviceManager.getInstance());
    }

    SdkAvdPreparer(IRunUtil runUtil, IDeviceManager deviceManager) {
        this.mRunUtil = runUtil;
        this.mDeviceManager = deviceManager;
    }

    @Override
    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, DeviceNotAvailableException, BuildError {
        Assert.assertTrue("Provided build is not a ISdkBuildInfo", buildInfo instanceof ISdkBuildInfo);
        ISdkBuildInfo sdkBuildInfo = (ISdkBuildInfo)buildInfo;
        this.launchEmulatorForAvd(sdkBuildInfo, device, this.createAvd(sdkBuildInfo));
    }

    public String createAvd(ISdkBuildInfo sdkBuildInfo) throws TargetSetupError, BuildError {
        String[] targets = this.getSdkTargets(sdkBuildInfo);
        this.setAndroidSdkHome(sdkBuildInfo);
        String target = this.findTargetToLaunch(targets);
        return this.createAvdForTarget(sdkBuildInfo, target);
    }

    public void launchEmulatorForAvd(ISdkBuildInfo sdkBuild, ITestDevice device, String avd) throws DeviceNotAvailableException, TargetSetupError, BuildError {
        if (!device.getDeviceState().equals((Object)TestDeviceState.NOT_AVAILABLE)) {
            LogUtil.CLog.w("Emulator %s is already running, killing", device.getSerialNumber());
            this.mDeviceManager.killEmulator(device);
        }
        List<String> emulatorArgs = ArrayUtil.list(sdkBuild.getEmulatorToolPath(), "-avd", avd);
        if (!this.mWindow) {
            emulatorArgs.add("-no-window");
        }
        if (this.mGpu) {
            emulatorArgs.add("-gpu");
            emulatorArgs.add("on");
        }
        this.launchEmulator(device, avd, emulatorArgs);
        if (!device.getIDevice().getAvdName().equals(avd)) {
            throw new BuildError(String.format("Emulator booted with incorrect avd name '%s'. Expected: '%s'.", device.getIDevice().getAvdName(), avd));
        }
    }

    public void setGpu(boolean gpu) {
        this.mGpu = gpu;
    }

    private String[] getSdkTargets(ISdkBuildInfo sdkBuild) throws TargetSetupError {
        CommandResult result = this.mRunUtil.runTimedCmd(15000L, sdkBuild.getAndroidToolPath(), "list", "targets", "--compact");
        if (!result.getStatus().equals((Object)CommandStatus.SUCCESS)) {
            throw new TargetSetupError(String.format("Unable to get list of SDK targets using %s. Result %s. stdout: %s, err: %s", new Object[]{sdkBuild.getAndroidToolPath(), result.getStatus(), result.getStdout(), result.getStderr()}));
        }
        String[] targets = result.getStdout().split("\n");
        if (result.getStdout().trim().isEmpty() || targets.length == 0) {
            throw new TargetSetupError(String.format("No targets found in SDK %s.", sdkBuild.getSdkDir().getAbsolutePath()));
        }
        return targets;
    }

    private void setAndroidSdkHome(ISdkBuildInfo sdkBuild) {
        this.mRunUtil.setEnvVariable("ANDROID_SDK_HOME", sdkBuild.getSdkDir().getAbsolutePath());
    }

    private String findTargetToLaunch(String[] targets) throws TargetSetupError {
        if (this.mTargetName != null) {
            for (String foundTarget : targets) {
                if (!foundTarget.equals(this.mTargetName)) continue;
                return this.mTargetName;
            }
            throw new TargetSetupError(String.format("Could not find target %s in sdk", this.mTargetName));
        }
        return targets[targets.length - 1];
    }

    private String createAvdForTarget(ISdkBuildInfo sdkBuild, String target) throws BuildError {
        CommandResult result;
        String cmdInput = "no\r\n";
        String successPattern = String.format("Created AVD '%s'", target);
        LogUtil.CLog.d("Creating avd for target %s with name %s", target, target);
        List<String> avdCommand = ArrayUtil.list(sdkBuild.getAndroidToolPath(), "create", "avd", "--target", target, "--name", target, "--sdcard", this.mSdcardSize, "--force");
        if (this.mAbi != null) {
            avdCommand.add("--abi");
            avdCommand.add(this.mAbi);
        }
        if (!(result = this.mRunUtil.runTimedCmdWithInput(15000L, "no\r\n", avdCommand)).getStatus().equals((Object)CommandStatus.SUCCESS) || result.getStdout() == null || !result.getStdout().contains(successPattern)) {
            LogUtil.CLog.d("AVD creation failed. stdout: %s", result.getStdout());
            throw new BuildError(String.format("Unable to create avd for target '%s'. stderr: '%s'", target, result.getStderr()));
        }
        return target;
    }

    void launchEmulator(ITestDevice device, String avd, List<String> emulatorArgs) throws BuildError {
        for (int i = 1; i <= this.mLaunchAttempts; ++i) {
            try {
                this.mDeviceManager.launchEmulator(device, this.mMaxBootTime * 60L * 1000L, this.mRunUtil, emulatorArgs);
                LogUtil.CLog.d("Testing adb to %s communication", device.getSerialNumber());
                for (int j = 0; j < 3; ++j) {
                    device.executeShellCommand("pm list instrumentation");
                    this.mRunUtil.sleep(2000L);
                }
                return;
            }
            catch (DeviceNotAvailableException e) {
                LogUtil.CLog.w("Emulator for avd '%s' failed to launch on attempt %d of %d. Cause: %s", avd, i, this.mLaunchAttempts, e);
                try {
                    this.mDeviceManager.killEmulator(device);
                }
                catch (DeviceNotAvailableException e2) {
                    // empty catch block
                }
                continue;
            }
        }
        throw new DeviceFailedToBootError(String.format("Emulator for avd '%s' failed to boot.", avd));
    }

    void setLaunchAttempts(int launchAttempts) {
        this.mLaunchAttempts = launchAttempts;
    }
}

