/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.VersionedFile;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.ITargetCleaner;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.FileUtil;
import java.io.File;

public class TestJarInstaller
implements ITargetPreparer,
ITargetCleaner {
    private static final String DATA_LOCAL_TMP = "/data/local/tmp/";
    @Option(name="uninstall", description="remove all jars after test completes.")
    private boolean mUninstall = true;

    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        for (VersionedFile buildFile : buildInfo.getFiles()) {
            File file = buildFile.getFile();
            LogUtil.CLog.d("Examining build file %s", file.getName());
            if (!this.isJarFile(file)) continue;
            String remotePath = String.format("%s%s", DATA_LOCAL_TMP, file.getName());
            LogUtil.CLog.d("Pushing %s to %s", file.getName(), remotePath);
            if (device.pushFile(file, remotePath)) continue;
            throw new TargetSetupError(String.format("Failed to push %s to %s", file.getName(), remotePath));
        }
    }

    private boolean isJarFile(File file) {
        return FileUtil.getExtension(file.getName()).equals(".jar");
    }

    public void tearDown(ITestDevice device, IBuildInfo buildInfo, Throwable e) throws DeviceNotAvailableException {
        if (this.mUninstall) {
            device.executeShellCommand(String.format("rm %s*.jar", DATA_LOCAL_TMP));
        }
    }
}

