/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;

public class TimeWaster
implements ITargetPreparer {
    @Option(name="delay", description="Time to delay, in msecs", mandatory=true)
    private long mDelayMsecs = 0L;
    @Option(name="reboot-before-sleep", description="Whether to reboot the device before sleeping")
    private boolean mRebootBeforeSleep = false;
    @Option(name="reboot-after-sleep", description="Whether to reboot the device after sleeping")
    private boolean mRebootAfterSleep = false;

    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, DeviceNotAvailableException {
        if (this.mRebootBeforeSleep) {
            LogUtil.CLog.d("Pre-sleep device reboot on %s", device.getSerialNumber());
            device.reboot();
        }
        LogUtil.CLog.d("Sleeping %d msecs on device %s", this.mDelayMsecs, device.getSerialNumber());
        this.getRunUtil().sleep(this.mDelayMsecs);
        if (this.mRebootAfterSleep) {
            LogUtil.CLog.d("Post-sleep device reboot on %s", device.getSerialNumber());
            device.reboot();
        }
    }

    IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }
}

