/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;

public class WifiPreparer
implements ITargetPreparer {
    @Option(name="wifi-network", description="the name of wifi network to connect to.", mandatory=true)
    private String mWifiNetwork = null;
    @Option(name="wifi-psk", description="WPA-PSK passphrase of wifi network to connect to.")
    private String mWifiPsk = null;
    @Option(name="wifi-attempts", description="maximum number of attempts to connect to wifi network.")
    private int mWifiAttempts = 2;

    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        for (int i = 1; i <= this.mWifiAttempts; ++i) {
            if (device.connectToWifiNetwork(this.mWifiNetwork, this.mWifiPsk)) {
                LogUtil.CLog.w("Successfully connected to wifi network %s on %s", this.mWifiNetwork, device.getSerialNumber());
                return;
            }
            LogUtil.CLog.w("Failed to connect to wifi network %s on %s on attempt %d of %d", this.mWifiNetwork, device.getSerialNumber(), i, this.mWifiAttempts);
        }
        throw new TargetSetupError(String.format("Failed to connect to wifi network %s on %s", this.mWifiNetwork, device.getSerialNumber()));
    }
}

