/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.ResultForwarder;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.testtype.InstrumentationTest;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.util.Map;

@OptionClass(alias="code-coverage")
public class CodeCoverageTest
extends InstrumentationTest {
    @Option(name="coverage-file", description="Optional custom emma coverage file path. If unspecified, will use package name.")
    private String mCoverageFile = null;
    private static final String COVERAGE_REMOTE_FILE_LABEL = "coverageFilePath";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(ITestInvocationListener listener) throws DeviceNotAvailableException {
        super.setRerunMode(false);
        super.addInstrumentationArg("coverage", "true");
        if (this.mCoverageFile != null) {
            super.addInstrumentationArg("coverageFile", this.mCoverageFile);
        }
        CollectingTestListener testCoverageFile = new CollectingTestListener();
        super.run(new ResultForwarder(listener, testCoverageFile));
        if (this.mCoverageFile == null) {
            this.mCoverageFile = this.fetchCoverageFilePath(testCoverageFile);
        }
        LogUtil.CLog.d("Coverage file at %s", this.mCoverageFile);
        File coverageFile = null;
        try {
            if (this.getDevice().doesFileExist(this.mCoverageFile)) {
                coverageFile = this.getDevice().pullFile(this.mCoverageFile);
                if (coverageFile != null) {
                    LogUtil.CLog.d("coverage file from device: %s", coverageFile.getAbsolutePath());
                    FileInputStreamSource source = new FileInputStreamSource(coverageFile);
                    listener.testLog(this.getPackageName() + "_runtime_coverage", LogDataType.COVERAGE, source);
                    source.cancel();
                }
            } else {
                LogUtil.CLog.w("Missing coverage file %s. Did test crash?", this.mCoverageFile);
            }
            Object var6_5 = null;
            if (coverageFile == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (coverageFile == null) throw throwable;
            FileUtil.deleteFile(coverageFile);
            throw throwable;
        }
        FileUtil.deleteFile(coverageFile);
    }

    private String fetchCoverageFilePath(CollectingTestListener listener) {
        TestRunResult runResult = listener.getCurrentRunResults();
        Map<String, String> metrics = runResult.getRunMetrics();
        return metrics.get(COVERAGE_REMOTE_FILE_LABEL);
    }
}

