/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.io.IOException;
import junit.framework.Assert;

@OptionClass(alias="battery-checker")
public class DeviceBatteryLevelChecker
implements IDeviceTest,
IRemoteTest {
    ITestDevice mTestDevice = null;
    @Option(name="max-battery", description="Charge level below which we force the device to sit and charge.  Range: 0-100.")
    private Integer mMaxBattery = 20;
    @Option(name="resume-level", description="Charge level at which we release the device to begin testing again. Range: 0-100.")
    private int mResumeLevel = 80;
    @Option(name="poll-time", description="Time in minutes to wait between battery level polls. Decimal times accepted.")
    private double mChargingPollTime = 1.0;
    @Option(name="batt-log-period", description="Min time in minutes to wait between printing current battery level to log.  Decimal times accepted.")
    private double mLoggingPollTime = 10.0;
    @Option(name="reboot-charging-devices", description="Whether to reboot a device when we detect that it should be held for charging.  This would hopefully kill any battery-draining processes and allow the device to charge at its fastest rate.")
    private boolean mRebootChargeDevices = false;

    Integer checkBatteryLevel(ITestDevice device) throws DeviceNotAvailableException {
        try {
            IDevice idevice = device.getIDevice();
            return idevice.getBatteryLevel(0L);
        }
        catch (AdbCommandRejectedException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        catch (TimeoutException e) {
            return null;
        }
        catch (ShellCommandUnresponsiveException e) {
            return null;
        }
    }

    public void run(ITestInvocationListener listener) throws DeviceNotAvailableException {
        Assert.assertNotNull(this.mTestDevice);
        Integer batteryLevel = this.checkBatteryLevel(this.mTestDevice);
        if (batteryLevel == null) {
            LogUtil.CLog.w("Failed to determine battery level for device %s.", this.mTestDevice.getSerialNumber());
            return;
        }
        if (batteryLevel >= this.mMaxBattery) {
            LogUtil.CLog.d("Battery level %d is above the minimum of %d; %s is good to go.", batteryLevel, this.mMaxBattery, this.mTestDevice.getSerialNumber());
            return;
        }
        LogUtil.CLog.w("Battery level %d is below the min level %d; holding for device %s to charge to level %d", batteryLevel, this.mMaxBattery, this.mTestDevice.getSerialNumber(), this.mResumeLevel);
        if (this.mRebootChargeDevices) {
            LogUtil.CLog.d("Rebooting device %s prior to holding", this.mTestDevice.getSerialNumber());
            this.mTestDevice.reboot();
        }
        Long lastReportTime = System.currentTimeMillis();
        Integer newLevel = this.checkBatteryLevel(this.mTestDevice);
        while (batteryLevel != null && batteryLevel < this.mResumeLevel) {
            if ((double)(System.currentTimeMillis() - lastReportTime) > this.mLoggingPollTime * 60.0 * 1000.0) {
                LogUtil.CLog.w("Battery level for device %s is currently %d", this.mTestDevice.getSerialNumber(), newLevel);
                lastReportTime = System.currentTimeMillis();
            }
            this.getRunUtil().sleep((long)(this.mChargingPollTime * 60.0 * 1000.0));
            newLevel = this.checkBatteryLevel(this.mTestDevice);
            if (newLevel == null) {
                LogUtil.CLog.w("Breaking out of wait loop because battery level read failed for device %s", this.mTestDevice.getSerialNumber());
                break;
            }
            if (newLevel < batteryLevel) {
                LogUtil.CLog.w("Warning: battery discharged from %d to %d on device %s during the last %.02f minutes.", batteryLevel, newLevel, this.mTestDevice.getSerialNumber(), this.mChargingPollTime);
            } else {
                LogUtil.CLog.v("Battery level for device %s is currently %d", this.mTestDevice.getSerialNumber(), newLevel);
            }
            batteryLevel = newLevel;
        }
        LogUtil.CLog.w("Device %s is now charged to battery level %d; releasing.", this.mTestDevice.getSerialNumber(), batteryLevel);
    }

    IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    public void setDevice(ITestDevice device) {
        this.mTestDevice = device;
    }

    public ITestDevice getDevice() {
        return this.mTestDevice;
    }
}

