/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.DeviceTestCase;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.JUnitRunUtil;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@OptionClass(alias="host")
public class HostTest
implements IDeviceTest,
IRemoteTest {
    @Option(name="class", description="The JUnit Test to run.", importance=Option.Importance.IF_UNSET)
    private String mClassName;
    @Option(name="method", description="The JUnit TestCase method to run.", importance=Option.Importance.IF_UNSET)
    private String mMethodName;
    private ITestDevice mDevice = null;

    @Override
    public ITestDevice getDevice() {
        return this.mDevice;
    }

    @Override
    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    public int countTestCases() {
        return 1;
    }

    void setClassName(String className) {
        this.mClassName = className;
    }

    void setMethodName(String methodName) {
        this.mMethodName = methodName;
    }

    @Override
    public void run(ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (this.mClassName == null) {
            throw new IllegalArgumentException("Missing Test class name");
        }
        Class<?> classObj = this.loadTestClass(this.mClassName);
        Object testObj = this.loadObject(classObj);
        if (testObj instanceof IDeviceTest) {
            if (this.mDevice == null) {
                throw new IllegalArgumentException("Missing device");
            }
            ((IDeviceTest)testObj).setDevice(this.mDevice);
        }
        if (testObj instanceof Test) {
            Test test = (Test)testObj;
            if (test instanceof TestCase) {
                if (this.mMethodName != null) {
                    ((TestCase)test).setName(this.mMethodName);
                } else if (!(test instanceof DeviceTestCase)) {
                    TestSuite testSuite = new TestSuite(classObj);
                    test = testSuite;
                }
            }
            JUnitRunUtil.runTest(listener, test);
        } else if (testObj instanceof IRemoteTest) {
            ((IRemoteTest)testObj).run(listener);
        } else {
            throw new IllegalArgumentException(String.format("%s is not a test", this.mClassName));
        }
    }

    private Class<?> loadTestClass(String className) throws IllegalArgumentException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("Could not load Test class %s", className), e);
        }
    }

    private Object loadObject(Class<?> classObj) throws IllegalArgumentException {
        String className = classObj.getName();
        try {
            Object testObject = classObj.newInstance();
            return testObject;
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(String.format("Could not load Test class %s", className), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(String.format("Could not load Test class %s", className), e);
        }
    }
}

