/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.ResultForwarder;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.InstrumentationTest;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InstrumentationListTest
implements IDeviceTest,
IRemoteTest {
    private static final String LOG_TAG = "InstrumentationListTest";
    static final int FAILED_RUN_TEST_ATTEMPTS = 2;
    private final String mPackageName;
    private final String mRunnerName;
    private final Collection<TestIdentifier> mTests;
    private int mTestTimeout = 600000;
    private ITestDevice mDevice = null;
    private String mRunName = null;

    InstrumentationListTest(String packageName, String runnerName, Collection<TestIdentifier> testsToRun) {
        this.mPackageName = packageName;
        this.mRunnerName = runnerName;
        this.mTests = testsToRun;
    }

    @Override
    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    void setTestTimeout(int timeout) {
        this.mTestTimeout = timeout;
    }

    public void setRunName(String runName) {
        this.mRunName = runName;
    }

    @Override
    public ITestDevice getDevice() {
        return this.mDevice;
    }

    InstrumentationTest createInstrumentationTest() {
        return new InstrumentationTest();
    }

    @Override
    public void run(ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (this.mDevice == null) {
            throw new IllegalArgumentException("Device has not been set");
        }
        for (TestIdentifier testToRun : this.mTests) {
            InstrumentationTest runner = this.createInstrumentationTest();
            runner.setDevice(this.mDevice);
            runner.setPackageName(this.mPackageName);
            runner.setRunnerName(this.mRunnerName);
            runner.setClassName(testToRun.getClassName());
            runner.setMethodName(testToRun.getTestName());
            runner.setTestTimeout(this.mTestTimeout);
            runner.setRerunMode(false);
            runner.setRunName(this.mRunName);
            this.runTest(runner, listener, testToRun);
        }
    }

    private void runTest(InstrumentationTest runner, ITestInvocationListener listener, TestIdentifier testToRun) throws DeviceNotAvailableException {
        TestTrackingListener trackingListener = new TestTrackingListener(listener, testToRun);
        for (int i = 1; i <= 2; ++i) {
            runner.run(trackingListener);
            if (trackingListener.didTestRun()) {
                return;
            }
            LogUtil.CLog.w("Expected test %s did not run on attempt %d of %d", testToRun, i, 2);
        }
        trackingListener.markTestAsFailed();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestTrackingListener
    extends ResultForwarder {
        private String mRunErrorMsg = null;
        private final TestIdentifier mExpectedTest;
        private boolean mDidTestRun = false;
        private String mRunName;

        public TestTrackingListener(ITestInvocationListener listener, TestIdentifier testToRun) {
            super(listener);
            this.mExpectedTest = testToRun;
        }

        @Override
        public void testRunStarted(String runName, int testCount) {
            super.testRunStarted(runName, testCount);
            this.mRunName = runName;
        }

        @Override
        public void testRunFailed(String errorMessage) {
            super.testRunFailed(errorMessage);
            this.mRunErrorMsg = errorMessage;
        }

        @Override
        public void testEnded(TestIdentifier test, Map<String, String> testMetrics) {
            super.testEnded(test, testMetrics);
            if (this.mExpectedTest.equals((Object)test)) {
                this.mDidTestRun = true;
            } else {
                Log.w((String)InstrumentationListTest.LOG_TAG, (String)String.format("Expected test %s, but got test %s", this.mExpectedTest, test));
            }
        }

        public boolean didTestRun() {
            return this.mDidTestRun;
        }

        public void markTestAsFailed() {
            super.testRunStarted(this.mRunName, 1);
            super.testStarted(this.mExpectedTest);
            super.testFailed(ITestRunListener.TestFailure.ERROR, this.mExpectedTest, String.format("Test failed to run. Test run failed due to : %s", this.mRunErrorMsg));
            if (this.mRunErrorMsg != null) {
                super.testRunFailed(this.mRunErrorMsg);
            }
            super.testEnded(this.mExpectedTest, Collections.EMPTY_MAP);
            super.testRunEnded(0L, Collections.EMPTY_MAP);
        }
    }
}

