/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.IFileEntry;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.NativeBenchmarkTestParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@OptionClass(alias="native-benchmark")
public class NativeBenchmarkTest
implements IDeviceTest,
IRemoteTest {
    private static final String LOG_TAG = "NativeStressTest";
    static final String DEFAULT_TEST_PATH = "data/nativebenchmark";
    static final String AVG_OP_TIME_KEY_PREFIX = "avg-operation-time";
    static final String ITERATION_KEY = "iterations";
    private ITestDevice mDevice = null;
    @Option(name="native-benchmark-device-path", description="The path on the device where native stress tests are located.")
    private String mDeviceTestPath = "data/nativebenchmark";
    @Option(name="benchmark-module-name", description="The name of the native benchmark test module to run. If not specified all tests in --native-benchmark-device-path will be run.")
    private String mTestModule = null;
    @Option(name="benchmark-run-name", description="Optional name to pass to test reporters. If unspecified, will use--benchmark-module-name.")
    private String mReportRunName = null;
    @Option(name="iterations", description="The number of benchmark test iterations per run.")
    private int mNumIterations = 1000;
    @Option(name="delay-per-run", description="The delay between each benchmark iteration, in micro seconds.Multiple values may be given to specify multiple runs with different delay values.")
    private Collection<Integer> mDelays = new ArrayList<Integer>();
    @Option(name="max-run-time", description="The maximum time to allow for one benchmark run in ms.")
    private int mMaxRunTime = 300000;
    @Option(name="server-cpu", description="Optionally specify a server cpu.")
    private int mServerCpu = 1;
    @Option(name="client-cpu", description="Optionally specify a client cpu.")
    private int mClientCpu = 1;
    @Option(name="max-cpu-freq", description="Flag to force device cpu to run at maximum frequency.")
    private boolean mMaxCpuFreq = false;

    @Override
    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    @Override
    public ITestDevice getDevice() {
        return this.mDevice;
    }

    public void setModuleName(String moduleName) {
        this.mTestModule = moduleName;
    }

    public String getModuleName(String moduleName) {
        return this.mTestModule;
    }

    void setNumIterations(int iterations) {
        this.mNumIterations = iterations;
    }

    void addDelaysPerRun(Collection<Integer> delays) {
        this.mDelays.addAll(delays);
    }

    private String getTestPath() {
        StringBuilder testPath = new StringBuilder(this.mDeviceTestPath);
        if (this.mTestModule != null) {
            testPath.append("/");
            testPath.append(this.mTestModule);
        }
        return testPath.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRunAllTestsInSubdirectory(IFileEntry rootEntry, ITestDevice testDevice, ITestRunListener listener) throws DeviceNotAvailableException {
        if (rootEntry.isDirectory()) {
            for (IFileEntry childEntry : rootEntry.getChildren(true)) {
                this.doRunAllTestsInSubdirectory(childEntry, testDevice, listener);
            }
        } else {
            String runName = this.mReportRunName == null ? rootEntry.getName() : this.mReportRunName;
            String fullPath = rootEntry.getFullEscapedPath();
            if (this.mDelays.size() == 0) {
                this.mDelays.add(0);
            }
            testDevice.executeShellCommand(String.format("chmod 755 %s", fullPath));
            long startTime = System.currentTimeMillis();
            listener.testRunStarted(runName, 0);
            HashMap<String, String> metricMap = new HashMap<String, String>();
            metricMap.put(ITERATION_KEY, Integer.toString(this.mNumIterations));
            try {
                for (Integer delay : this.mDelays) {
                    NativeBenchmarkTestParser resultParser = this.createResultParser(runName);
                    double delayFloat = (double)delay.intValue() / 1000000.0;
                    Log.i((String)LOG_TAG, (String)String.format("Running %s for %d iterations with delay %f", rootEntry.getName(), this.mNumIterations, delayFloat));
                    String cmd = String.format("%s -n %d -d %f -c %d -s %d", fullPath, this.mNumIterations, delayFloat, this.mClientCpu, this.mServerCpu);
                    Log.i((String)LOG_TAG, (String)String.format("Running native benchmark test on %s: %s", this.mDevice.getSerialNumber(), cmd));
                    testDevice.executeShellCommand(cmd, (IShellOutputReceiver)resultParser, this.mMaxRunTime, 0);
                    this.addMetric(metricMap, resultParser, delay);
                }
                Object var16_15 = null;
            }
            catch (Throwable throwable) {
                Object var16_16 = null;
                long elapsedTime = System.currentTimeMillis() - startTime;
                listener.testRunEnded(elapsedTime, metricMap);
                throw throwable;
            }
            long elapsedTime = System.currentTimeMillis() - startTime;
            listener.testRunEnded(elapsedTime, metricMap);
            {
            }
        }
    }

    private void addMetric(Map<String, String> metricMap, NativeBenchmarkTestParser resultParser, Integer delay) {
        String metricKey = String.format("%s-delay%d", AVG_OP_TIME_KEY_PREFIX, delay);
        metricMap.put(metricKey, Double.toString(resultParser.getAvgOperationTime() * 1000000.0));
    }

    NativeBenchmarkTestParser createResultParser(String runName) {
        return new NativeBenchmarkTestParser(runName);
    }

    @Override
    public void run(ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (this.mDevice == null) {
            throw new IllegalArgumentException("Device has not been set");
        }
        String testPath = this.getTestPath();
        IFileEntry nativeTestDirectory = this.mDevice.getFileEntry(testPath);
        if (nativeTestDirectory == null) {
            Log.w((String)LOG_TAG, (String)String.format("Could not find native benchmark test directory %s in %s!", testPath, this.mDevice.getSerialNumber()));
            return;
        }
        if (this.mMaxCpuFreq) {
            this.mDevice.executeShellCommand("cat /sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq > /sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq");
        }
        this.doRunAllTestsInSubdirectory(nativeTestDirectory, this.mDevice, listener);
        if (this.mMaxCpuFreq) {
            this.mDevice.executeShellCommand("cat /sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq > /sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq");
        }
    }
}

