/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.testrunner.IRemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.RemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.StubTestInvocationListener;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.UiAutomatorRunner;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UiAutomatorTest
implements IRemoteTest,
IDeviceTest {
    private static final String SHELL_EXE_BASE = "/data/local/tmp/";
    private ITestDevice mDevice = null;
    private IRemoteAndroidTestRunner mRunner = null;
    @Option(name="jar-path", description="path to jars containing UI Automator test cases and dependencies; May be repeated. If unspecified will use all jars found in /data/local/tmp/")
    private List<String> mJarPaths = new ArrayList<String>();
    @Option(name="class", description="test class to run, may be repeated; multiple classess will be run in the same order as provided in command line")
    private List<String> mClasses = new ArrayList<String>();
    @Option(name="sync-time", description="time to allow for initial sync, in ms")
    private long mSyncTime = 0L;
    @Option(name="run-arg", description="Additional test specific arguments to provide.")
    private Map<String, String> mArgMap = new LinkedHashMap<String, String>();
    @Option(name="timeout", description="Aborts the test run if any test takes longer than the specified number of milliseconds. For no timeout, set to 0.")
    private int mTestTimeout = 1800000;
    @Option(name="capture-logs", description="capture bugreport and screenshot as specified.")
    private LoggingOption mLoggingOption = LoggingOption.AFTER_FAILURE;
    @Option(name="runner-path", description="path to uiautomator runner; may be null and default will be used in this case")
    private String mRunnerPath = null;
    @Option(name="on-test-failure", description="sets the action to perform if a test fails")
    private TestFailureAction mFailureAction = TestFailureAction.BUGREPORT_AND_SCREENSHOT;
    @Option(name="ignore-sighup", description="allows uiautomator test to ignore SIGHUP signal")
    private boolean mIgnoreSighup = false;
    @Option(name="run-name", description="the run name to use when reporting test results.")
    private String mRunName = "uiautomator";
    @Option(name="instrumentation", description="the specified test should be driven with instrumentation.jar-path, runner-path, ignore-sighup are ignored when this is set.")
    private boolean mInstrumentation = false;
    @Option(name="package", description="The manifest package name of the UI test package.Only applies when 'instrumentation' option is set.")
    private String mPackage = null;
    @Option(name="runner", description="The instrumentation based test runner class name to use.Only applies when 'instrumentation' option is set.")
    private String mRunnerName = "com.android.uiautomator.testrunner.UiAutomatorInstrumentationTestRunner";

    @Override
    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    @Override
    public ITestDevice getDevice() {
        return this.mDevice;
    }

    public void setLoggingOption(LoggingOption loggingOption) {
        this.mLoggingOption = loggingOption;
    }

    @Deprecated
    public void setCaptureLogs(boolean captureLogs) {
        if (captureLogs) {
            this.setLoggingOption(LoggingOption.AFTER_FAILURE);
        } else {
            this.setLoggingOption(LoggingOption.OFF);
        }
    }

    public void setRunName(String runName) {
        this.mRunName = runName;
    }

    @Override
    public void run(ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (!this.isInstrumentationTest()) {
            this.buildJarPaths();
        }
        this.mRunner = this.createTestRunner();
        if (!this.mClasses.isEmpty()) {
            this.getTestRunner().setClassNames(this.mClasses.toArray(new String[0]));
        }
        this.getTestRunner().setRunName(this.mRunName);
        this.preTestSetup();
        this.getRunUtil().sleep(this.getSyncTime());
        this.getTestRunner().setMaxtimeToOutputResponse(this.mTestTimeout);
        for (Map.Entry<String, String> entry : this.getTestRunArgMap().entrySet()) {
            this.getTestRunner().addInstrumentationArg(entry.getKey(), entry.getValue());
        }
        if (!this.isInstrumentationTest()) {
            ((UiAutomatorRunner)this.getTestRunner()).setIgnoreSighup(this.mIgnoreSighup);
        }
        if (this.mLoggingOption != LoggingOption.OFF) {
            this.getDevice().runInstrumentationTests(this.getTestRunner(), listener, new LoggingWrapper(listener));
        } else {
            this.getDevice().runInstrumentationTests(this.getTestRunner(), listener);
        }
    }

    protected IRemoteAndroidTestRunner createTestRunner() {
        if (this.isInstrumentationTest()) {
            RemoteAndroidTestRunner runner = new RemoteAndroidTestRunner(this.mPackage, this.mRunnerName, this.getDevice().getIDevice());
            return runner;
        }
        return new UiAutomatorRunner(this.getDevice().getIDevice(), this.getTestJarPaths().toArray(new String[0]), this.mRunnerPath);
    }

    private void buildJarPaths() throws DeviceNotAvailableException {
        if (this.mJarPaths.isEmpty()) {
            String[] rawFiles;
            String rawFileString = this.getDevice().executeShellCommand(String.format("ls %s", SHELL_EXE_BASE));
            for (String rawFile : rawFiles = rawFileString.split("\r\n")) {
                if (!rawFile.endsWith(".jar")) continue;
                this.mJarPaths.add(rawFile);
            }
            Assert.assertFalse(String.format("could not find jars in %s", SHELL_EXE_BASE), this.mJarPaths.isEmpty());
            LogUtil.CLog.d("built jar paths %s", this.mJarPaths);
        }
    }

    public void addRunArg(String key, String value) {
        this.getTestRunArgMap().put(key, value);
    }

    protected void preTestSetup() throws DeviceNotAvailableException {
        if (!this.isInstrumentationTest()) {
            String runnerPath = ((UiAutomatorRunner)this.getTestRunner()).getRunnerPath();
            if (!this.getDevice().doesFileExist(runnerPath)) {
                throw new RuntimeException("Missing UI Automator runner: " + runnerPath);
            }
            for (String jarPath : this.getTestJarPaths()) {
                if (!jarPath.startsWith("/")) {
                    jarPath = SHELL_EXE_BASE + jarPath;
                }
                if (this.getDevice().doesFileExist(jarPath)) continue;
                throw new RuntimeException("Missing UI Automator test jar on device: " + jarPath);
            }
        }
    }

    protected IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    public long getSyncTime() {
        return this.mSyncTime;
    }

    public void setSyncTime(long syncTime) {
        this.mSyncTime = syncTime;
    }

    public IRemoteAndroidTestRunner getTestRunner() {
        return this.mRunner;
    }

    public List<String> getTestJarPaths() {
        return this.mJarPaths;
    }

    public void setTestJarPaths(List<String> jarPaths) {
        this.mJarPaths = jarPaths;
    }

    public Map<String, String> getTestRunArgMap() {
        return this.mArgMap;
    }

    public void setTestRunArgMap(Map<String, String> runArgMap) {
        this.mArgMap = runArgMap;
    }

    public void addClassName(String className) {
        this.mClasses.add(className);
    }

    public void addClassNames(Collection<String> classNames) {
        this.mClasses.addAll(classNames);
    }

    public boolean isInstrumentationTest() {
        return this.mInstrumentation;
    }

    public void setRunnerName(String runnerName) {
        this.mRunnerName = runnerName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LoggingWrapper
    extends StubTestInvocationListener {
        ITestInvocationListener mListener;
        private boolean mLoggedFailure = false;

        public LoggingWrapper(ITestInvocationListener listener) {
            this.mListener = listener;
        }

        @Override
        public void testFailed(ITestRunListener.TestFailure status, TestIdentifier test, String trace) {
            if (UiAutomatorTest.this.mLoggingOption == LoggingOption.AFTER_FAILURE) {
                this.doScreenshotAndBugreport(String.format("%s_%s_failure", test.getClassName(), test.getTestName()));
                this.mLoggedFailure = true;
            }
        }

        @Override
        public void testEnded(TestIdentifier test, Map<String, String> testMetrics) {
            if (!this.mLoggedFailure && UiAutomatorTest.this.mLoggingOption == LoggingOption.AFTER_TEST) {
                this.doScreenshotAndBugreport(String.format("%s_%s_final", test.getClassName(), test.getTestName()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doScreenshotAndBugreport(String prefix) {
            InputStreamSource data = null;
            if (UiAutomatorTest.this.mFailureAction == TestFailureAction.SCREENSHOT || UiAutomatorTest.this.mFailureAction == TestFailureAction.BUGREPORT_AND_SCREENSHOT) {
                try {
                    try {
                        data = UiAutomatorTest.this.getDevice().getScreenshot();
                        this.mListener.testLog(prefix + "_screenshot", LogDataType.PNG, data);
                    }
                    catch (DeviceNotAvailableException e) {
                        LogUtil.CLog.e(e);
                        Object var5_4 = null;
                        if (data != null) {
                            data.cancel();
                        }
                    }
                    Object var5_3 = null;
                    if (data != null) {
                        data.cancel();
                    }
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (data != null) {
                        data.cancel();
                    }
                    throw throwable;
                }
            }
            if (UiAutomatorTest.this.mFailureAction == TestFailureAction.BUGREPORT || UiAutomatorTest.this.mFailureAction == TestFailureAction.BUGREPORT_AND_SCREENSHOT) {
                data = UiAutomatorTest.this.getDevice().getBugreport();
                this.mListener.testLog(prefix + "_bugreport", LogDataType.TEXT, data);
                if (data != null) {
                    data.cancel();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TestFailureAction {
        BUGREPORT,
        SCREENSHOT,
        BUGREPORT_AND_SCREENSHOT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LoggingOption {
        AFTER_TEST,
        AFTER_FAILURE,
        OFF;

    }
}

