/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.testdefs;

import com.android.tradefed.testtype.testdefs.InstrumentationTestDef;
import com.android.tradefed.util.xml.AbstractXmlParser;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XmlDefsParser
extends AbstractXmlParser {
    private Map<String, InstrumentationTestDef> mTestDefsMap = new LinkedHashMap<String, InstrumentationTestDef>();

    XmlDefsParser() {
    }

    public Collection<InstrumentationTestDef> getTestDefs() {
        return this.mTestDefsMap.values();
    }

    @Override
    protected DefaultHandler createXmlHandler() {
        return new DefsHandler();
    }

    private class DefsHandler
    extends DefaultHandler {
        private static final String TEST_TAG = "test";

        private DefsHandler() {
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (TEST_TAG.equals(localName)) {
                String defName = attributes.getValue("name");
                InstrumentationTestDef def = new InstrumentationTestDef(defName, attributes.getValue("package"));
                def.setClassName(attributes.getValue("class"));
                def.setRunner(attributes.getValue("runner"));
                def.setContinuous("true".equals(attributes.getValue("continuous")));
                def.setCoverageTarget(attributes.getValue("coverage_target"));
                XmlDefsParser.this.mTestDefsMap.put(defName, def);
            }
        }
    }
}

