/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.RunUtil;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AaptParser {
    private String mPackageName;

    AaptParser() {
    }

    void parse(String aaptOut) {
        Pattern p = Pattern.compile("package: name='(.*?)'");
        Matcher m = p.matcher(aaptOut);
        if (m.find()) {
            this.mPackageName = m.group(1);
        } else {
            LogUtil.CLog.e("Failed to parse package name from 'aapt dump badging'");
        }
    }

    public static AaptParser parse(File apkFile) {
        CommandResult result = RunUtil.getDefault().runTimedCmd(5000L, "aapt", "dump", "badging", apkFile.getAbsolutePath());
        if (result.getStatus() == CommandStatus.SUCCESS) {
            AaptParser p = new AaptParser();
            p.parse(result.getStdout());
            return p;
        }
        LogUtil.CLog.e("Failed to run aapt on %s", apkFile.getAbsoluteFile());
        return null;
    }

    public String getPackageName() {
        return this.mPackageName;
    }
}

