/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.Email;
import com.android.tradefed.util.IEmail;
import java.io.IOException;

@OptionClass(alias="emailer")
public class BulkEmailer {
    @Option(name="total-emails", description="total number of emails to send", importance=Option.Importance.IF_UNSET)
    private int mEmails = 0;
    @Option(name="recipients", description="a comma separate list of recipient email addresses", importance=Option.Importance.IF_UNSET)
    private String mRecipients = null;
    @Option(name="send-interval", description="email send interval in milliseconds", importance=Option.Importance.IF_UNSET)
    private int mInterval = 0;
    @Option(name="initial-burst", description="initial burst of email to send", importance=Option.Importance.IF_UNSET)
    private int mInitialBurst = 0;
    @Option(name="sender", description="the sender email.", importance=Option.Importance.NEVER)
    private String mSender = "android.sync.battery.test@gmail.com";
    private static final String SUBJECT = "No emails to send";
    private static final String MESSAGE = "This is a test message!";

    public void sendEmailsBg() {
        new Thread(new Runnable(){

            public void run() {
                BulkEmailer.this.sendEmails();
            }
        }).start();
    }

    public void sendEmails() {
        if (this.mEmails == 0) {
            LogUtil.CLog.d("No emails to send.");
            return;
        }
        IEmail.Message msg = new IEmail.Message();
        msg.setTos(this.mRecipients.split(","));
        msg.setBody(MESSAGE);
        msg.setSender(this.mSender);
        Email email = new Email();
        try {
            int i;
            LogUtil.CLog.d("Sending initial burst of %d emails\n", this.mInitialBurst);
            for (i = 1; i <= this.mInitialBurst; ++i) {
                msg.setSubject(SUBJECT + i);
                email.send(msg);
                Thread.sleep(2000L);
            }
            for (i = this.mInitialBurst; i <= this.mEmails; ++i) {
                msg.setSubject(SUBJECT + i);
                email.send(msg);
                LogUtil.CLog.i("Sending email %d/%d", i, this.mEmails);
                Thread.sleep(this.mInterval);
            }
        }
        catch (IOException iox) {
            LogUtil.CLog.e("exception sending email");
            LogUtil.CLog.e(iox);
        }
        catch (InterruptedException ix) {
            LogUtil.CLog.e("sleep interrupted");
            LogUtil.CLog.e(ix);
        }
    }

    public static BulkEmailer loadMailer(IConfiguration config) throws ConfigurationException {
        Object o = config.getConfigurationObject("emailer");
        if (o instanceof BulkEmailer) {
            return (BulkEmailer)o;
        }
        throw new ConfigurationException("Missing or invalid emailer definition in config");
    }
}

