/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.ddmlib.Log;
import com.android.tradefed.util.IEmail;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Email
implements IEmail {
    private static final String LOG_TAG = "Email";
    private static final String[] mailer = new String[]{"/usr/sbin/sendmail", "-t", "-i"};
    static final String CRLF = "\r\n";

    private static String join(Collection<String> list, String sep) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> iter = list.iterator();
        while (iter.hasNext()) {
            String element = iter.next();
            builder.append(element);
            if (!iter.hasNext()) continue;
            builder.append(sep);
        }
        return builder.toString();
    }

    Process run(String[] cmd) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.redirectErrorStream(true);
        return pb.start();
    }

    private void addHeader(List<String> headers, String name, String value) {
        if (name == null || value == null) {
            return;
        }
        headers.add(String.format("%s: %s", name, value));
    }

    private void addHeaders(List<String> headers, String name, Collection<String> values) {
        if (name == null || values == null) {
            return;
        }
        if (values.isEmpty()) {
            return;
        }
        String strValues = Email.join(values, ",");
        headers.add(String.format("%s: %s", name, strValues));
    }

    @Override
    public void send(IEmail.Message msg) throws IllegalArgumentException, IOException {
        int retValue;
        Object[] mailCmd;
        if (msg.getTo() == null) {
            throw new IllegalArgumentException("Message is missing a destination");
        }
        if (msg.getSubject() == null) {
            throw new IllegalArgumentException("Message is missing a subject");
        }
        if (msg.getBody() == null) {
            throw new IllegalArgumentException("Message is missing a body");
        }
        ArrayList<String> headers = new ArrayList<String>();
        if (msg.getSender() != null) {
            this.addHeader(headers, "From", msg.getSender());
            int cmdLen = mailer.length + 2;
            mailCmd = Arrays.copyOf(mailer, cmdLen);
            mailCmd[cmdLen - 2] = "-f";
            mailCmd[cmdLen - 1] = msg.getSender();
        } else {
            mailCmd = mailer;
        }
        this.addHeaders(headers, "To", msg.getTo());
        this.addHeaders(headers, "Cc", msg.getCc());
        this.addHeaders(headers, "Bcc", msg.getBcc());
        this.addHeader(headers, "Content-type", msg.getContentType());
        this.addHeader(headers, "Subject", msg.getSubject());
        StringBuilder fullMsg = new StringBuilder();
        fullMsg.append(Email.join(headers, CRLF));
        fullMsg.append(CRLF);
        fullMsg.append(CRLF);
        fullMsg.append(msg.getBody());
        Log.d((String)LOG_TAG, (String)String.format("About to send email with command: %s", Arrays.toString(mailCmd)));
        Process mailerProc = this.run((String[])mailCmd);
        BufferedOutputStream mailerStdin = new BufferedOutputStream(mailerProc.getOutputStream());
        mailerStdin.write(fullMsg.toString().getBytes("UTF-8"));
        mailerStdin.flush();
        mailerStdin.close();
        try {
            retValue = mailerProc.waitFor();
        }
        catch (InterruptedException e) {
            retValue = -12345;
        }
        if (retValue != 0) {
            int theByte;
            Log.e((String)LOG_TAG, (String)String.format("Mailer finished with non-zero return value: %d", retValue));
            BufferedInputStream mailerStdout = new BufferedInputStream(mailerProc.getInputStream());
            StringBuilder stdout = new StringBuilder();
            while ((theByte = mailerStdout.read()) != -1) {
                stdout.append((char)theByte);
            }
            Log.e((String)LOG_TAG, (String)("Mailer output was: " + stdout.toString()));
        } else {
            Log.v((String)LOG_TAG, (String)"Mailer returned successfully.");
        }
    }
}

