/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.ddmlib.Log;
import com.android.tradefed.command.FatalHostError;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.StreamUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    private static final String LOG_TAG = "FileUtil";
    private static final long MIN_DISK_SPACE_MB = 100L;
    private static final long MIN_DISK_SPACE = 0x6400000L;
    private static final char[] SIZE_SPECIFIERS = new char[]{' ', 'K', 'M', 'G', 'T'};

    public static boolean mkdirsRWX(File file) {
        boolean setPerms;
        File parent = file.getParentFile();
        if (parent != null && !parent.isDirectory() && !FileUtil.mkdirsRWX(parent)) {
            Log.w((String)LOG_TAG, (String)String.format("Failed to mkdir parent dir %s.", parent));
            return false;
        }
        if ((file.isDirectory() || file.mkdir()) && !(setPerms = FileUtil.chmodGroupRWX(file))) {
            Log.w((String)LOG_TAG, (String)String.format("Failed to set dir %s to be group accessible.", file));
        }
        return file.isDirectory();
    }

    public static boolean chmodRWXRecursively(File file) {
        boolean success = true;
        if (!file.setExecutable(true, false)) {
            LogUtil.CLog.w("Failed to set %s executable.", file.getAbsolutePath());
            success = false;
        }
        if (!file.setWritable(true, false)) {
            LogUtil.CLog.w("Failed to set %s writable.", file.getAbsolutePath());
            success = false;
        }
        if (!file.setReadable(true, false)) {
            LogUtil.CLog.w("Failed to set %s readable", file.getAbsolutePath());
            success = false;
        }
        if (file.isDirectory()) {
            File[] childs;
            for (File child : childs = file.listFiles()) {
                if (FileUtil.chmodRWXRecursively(child)) continue;
                success = false;
            }
        }
        return success;
    }

    public static boolean chmod(File file, String perms) {
        Log.d((String)LOG_TAG, (String)String.format("Attempting to chmod %s to %s", file.getAbsolutePath(), perms));
        CommandResult result = RunUtil.getDefault().runTimedCmd(10000L, "chmod", perms, file.getAbsolutePath());
        return result.getStatus().equals((Object)CommandStatus.SUCCESS);
    }

    public static boolean chmodGroupRW(File file) {
        if (FileUtil.chmod(file, "ug+rw")) {
            return true;
        }
        Log.d((String)LOG_TAG, (String)String.format("Failed chmod; attempting to set %s globally RW", file.getAbsolutePath()));
        return file.setWritable(true, false) && file.setReadable(true, false);
    }

    public static boolean chmodGroupRWX(File file) {
        if (FileUtil.chmod(file, "ug+rwx")) {
            return true;
        }
        Log.d((String)LOG_TAG, (String)String.format("Failed chmod; attempting to set %s globally RWX", file.getAbsolutePath()));
        return file.setExecutable(true, false) && file.setWritable(true, false) && file.setReadable(true, false);
    }

    public static File createTempDir(String prefix) throws IOException {
        return FileUtil.createTempDir(prefix, null);
    }

    public static File createTempDir(String prefix, File parentDir) throws IOException {
        File tmpDir = File.createTempFile(prefix, "", parentDir);
        tmpDir.delete();
        if (!tmpDir.mkdirs()) {
            throw new IOException("unable to create directory");
        }
        return tmpDir;
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        File returnFile = File.createTempFile(prefix, suffix);
        FileUtil.verifyDiskSpace(returnFile);
        return returnFile;
    }

    public static File createTempFile(String prefix, String suffix, File parentDir) throws IOException {
        File returnFile = File.createTempFile(prefix, suffix, parentDir);
        FileUtil.verifyDiskSpace(returnFile);
        return returnFile;
    }

    public static void hardlinkFile(File origFile, File destFile) throws IOException {
        if (!origFile.exists()) {
            throw new IOException(String.format("Cannot hardlink %s. File does not exist", origFile.getAbsolutePath()));
        }
        CommandResult result = RunUtil.getDefault().runTimedCmd(10000L, "ln", origFile.getAbsolutePath(), destFile.getAbsolutePath());
        if (!result.getStatus().equals((Object)CommandStatus.SUCCESS)) {
            throw new IOException(String.format("Failed to hardlink %s to %s.  Across filesystem boundary?", origFile.getAbsolutePath(), destFile.getAbsolutePath()));
        }
    }

    public static void recursiveHardlink(File sourceDir, File destDir) throws IOException {
        for (File childFile : sourceDir.listFiles()) {
            File destChild = new File(destDir, childFile.getName());
            if (childFile.isDirectory()) {
                if (!destChild.mkdir()) {
                    throw new IOException(String.format("Could not create directory %s", destChild.getAbsolutePath()));
                }
                FileUtil.recursiveHardlink(childFile, destChild);
                continue;
            }
            if (!childFile.isFile()) continue;
            FileUtil.hardlinkFile(childFile, destChild);
        }
    }

    public static void copyFile(File origFile, File destFile) throws IOException {
        FileUtil.writeToFile(new FileInputStream(origFile), destFile);
    }

    public static void recursiveCopy(File sourceDir, File destDir) throws IOException {
        File[] childFiles = sourceDir.listFiles();
        if (childFiles == null) {
            throw new IOException(String.format("Failed to recursively copy. Could not determine contents for directory '%s'", sourceDir.getAbsolutePath()));
        }
        for (File childFile : childFiles) {
            File destChild = new File(destDir, childFile.getName());
            if (childFile.isDirectory()) {
                if (!destChild.mkdir()) {
                    throw new IOException(String.format("Could not create directory %s", destChild.getAbsolutePath()));
                }
                FileUtil.recursiveCopy(childFile, destChild);
                continue;
            }
            if (!childFile.isFile()) continue;
            FileUtil.copyFile(childFile, destChild);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStringFromFile(File sourceFile) throws IOException {
        String string;
        FileInputStream is = null;
        try {
            is = new FileInputStream(sourceFile);
            string = StreamUtil.getStringFromStream(is);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            StreamUtil.close(is);
            throw throwable;
        }
        StreamUtil.close(is);
        return string;
    }

    public static void writeToFile(String inputString, File destFile) throws IOException {
        FileUtil.writeToFile(new ByteArrayInputStream(inputString.getBytes()), destFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(InputStream input, File destFile) throws IOException {
        BufferedInputStream origStream = null;
        BufferedOutputStream destStream = null;
        try {
            origStream = new BufferedInputStream(input);
            destStream = new BufferedOutputStream(new FileOutputStream(destFile));
            StreamUtil.copyStreams(origStream, destStream);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            StreamUtil.close(origStream);
            StreamUtil.close(destStream);
            throw throwable;
        }
        StreamUtil.close(origStream);
        StreamUtil.close(destStream);
    }

    private static void verifyDiskSpace(File file) {
        if (file.getUsableSpace() < 0x6400000L) {
            throw new LowDiskSpaceException(String.format("Available space on %s is less than %s MB", file.getAbsolutePath(), 100L));
        }
    }

    public static void recursiveDelete(File rootDir) {
        File[] childFiles;
        if (rootDir.isDirectory() && (childFiles = rootDir.listFiles()) != null) {
            for (File child : childFiles) {
                FileUtil.recursiveDelete(child);
            }
        }
        rootDir.delete();
    }

    public static void extractZip(ZipFile zipFile, File destDir) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            File childFile = new File(destDir, entry.getName());
            childFile.getParentFile().mkdirs();
            if (entry.isDirectory()) continue;
            FileUtil.writeToFile(zipFile.getInputStream(entry), childFile);
        }
    }

    public static File extractFileFromZip(ZipFile zipFile, String filePath) throws IOException {
        ZipEntry entry = zipFile.getEntry(filePath);
        if (entry == null) {
            return null;
        }
        File createdFile = FileUtil.createTempFile("extracted", FileUtil.getExtension(filePath));
        FileUtil.writeToFile(zipFile.getInputStream(entry), createdFile);
        return createdFile;
    }

    public static File createZip(File dir) throws IOException {
        File zipFile = FileUtil.createTempFile("dir", ".zip");
        FileUtil.createZip(dir, zipFile);
        return zipFile;
    }

    public static void createZip(File dir, File zipFile) throws IOException {
        ZipOutputStream out = null;
        try {
            try {
                FileOutputStream fileStream = new FileOutputStream(zipFile);
                out = new ZipOutputStream(new BufferedOutputStream(fileStream));
                FileUtil.addToZip(out, dir, new LinkedList<String>());
            }
            catch (IOException e) {
                zipFile.delete();
                throw e;
            }
            catch (RuntimeException e) {
                zipFile.delete();
                throw e;
            }
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            StreamUtil.close(out);
            throw throwable;
        }
        StreamUtil.close(out);
    }

    private static void addToZip(ZipOutputStream out, File file, List<String> relativePathSegs) throws IOException {
        relativePathSegs.add(file.getName());
        if (file.isDirectory()) {
            relativePathSegs.add("/");
        }
        ZipEntry zipEntry = new ZipEntry(FileUtil.buildPath(relativePathSegs));
        out.putNextEntry(zipEntry);
        if (file.isFile()) {
            FileUtil.writeToStream(file, out);
        }
        out.closeEntry();
        if (file.isDirectory()) {
            File[] subFiles = file.listFiles();
            if (subFiles == null) {
                throw new IOException(String.format("Could not read directory %s", file.getAbsolutePath()));
            }
            for (File subFile : subFiles) {
                FileUtil.addToZip(out, subFile, relativePathSegs);
            }
            relativePathSegs.remove(relativePathSegs.size() - 1);
        }
        relativePathSegs.remove(relativePathSegs.size() - 1);
    }

    public static void closeZip(ZipFile otaZip) {
        if (otaZip != null) {
            try {
                otaZip.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void gzipFile(File file, File gzipFile) throws IOException {
        GZIPOutputStream out = null;
        try {
            try {
                FileOutputStream fileStream = new FileOutputStream(gzipFile);
                out = new GZIPOutputStream(new BufferedOutputStream(fileStream, 65536));
                FileUtil.writeToStream(file, out);
            }
            catch (IOException e) {
                gzipFile.delete();
                throw e;
            }
            catch (RuntimeException e) {
                gzipFile.delete();
                throw e;
            }
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            StreamUtil.close(out);
            throw throwable;
        }
        StreamUtil.close(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToStream(File file, OutputStream out) throws IOException {
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            StreamUtil.copyStreams(inputStream, out);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            StreamUtil.close(inputStream);
            throw throwable;
        }
        StreamUtil.close(inputStream);
    }

    private static String buildPath(List<String> relativePathSegs) {
        StringBuilder pathBuilder = new StringBuilder();
        for (String segment : relativePathSegs) {
            pathBuilder.append(segment);
        }
        return pathBuilder.toString();
    }

    public static String getExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return fileName.substring(index);
    }

    public static String getBaseName(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return fileName;
        }
        return fileName.substring(0, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compareFileContents(File file1, File file2) throws IOException {
        BufferedInputStream stream1 = null;
        BufferedInputStream stream2 = null;
        boolean result = true;
        try {
            stream1 = new BufferedInputStream(new FileInputStream(file1));
            stream2 = new BufferedInputStream(new FileInputStream(file2));
            boolean eof = false;
            while (!eof) {
                int byte2;
                int byte1 = stream1.read();
                if (byte1 != (byte2 = stream2.read())) {
                    result = false;
                    break;
                }
                eof = byte1 == -1;
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            StreamUtil.close(stream1);
            StreamUtil.close(stream2);
            throw throwable;
        }
        StreamUtil.close(stream1);
        StreamUtil.close(stream2);
        return result;
    }

    public static File createTempFileForRemote(String remoteFilePath, File parentDir) throws IOException {
        String[] segments = remoteFilePath.split("/");
        String remoteFileName = segments[segments.length - 1];
        String prefix = FileUtil.getBaseName(remoteFileName);
        if (prefix.length() < 3) {
            prefix = prefix + "XXX";
        }
        String fileExt = FileUtil.getExtension(remoteFileName);
        File tmpFile = FileUtil.createTempFile(prefix + "_", fileExt, parentDir);
        return tmpFile;
    }

    public static void deleteFile(File file) {
        if (file != null) {
            file.delete();
        }
    }

    public static File getFileForPath(File parentDir, String ... pathSegments) {
        return new File(parentDir, FileUtil.getPath(pathSegments));
    }

    public static String getPath(String ... pathSegments) {
        StringBuilder pathBuilder = new StringBuilder();
        boolean isFirst = true;
        for (String path : pathSegments) {
            if (!isFirst) {
                pathBuilder.append(File.separatorChar);
            } else {
                isFirst = false;
            }
            pathBuilder.append(path);
        }
        return pathBuilder.toString();
    }

    public static File findFile(File dir, String fileName) {
        if (dir.listFiles() != null) {
            for (File file : dir.listFiles()) {
                File result;
                if (file.getName().equals(fileName)) {
                    return file;
                }
                if (!file.isDirectory() || (result = FileUtil.findFile(file, fileName)) == null) continue;
                return result;
            }
        }
        return null;
    }

    public static Set<File> findDirsUnder(File rootDir, File relativeParent) {
        HashSet<File> dirs = new HashSet<File>();
        if (rootDir != null) {
            if (!rootDir.isDirectory()) {
                throw new IllegalArgumentException("Can't find dirs under '" + rootDir + "'. It's not a directory.");
            }
            File thisDir = new File(relativeParent, rootDir.getName());
            dirs.add(thisDir);
            for (File file : rootDir.listFiles()) {
                if (!file.isDirectory()) continue;
                dirs.addAll(FileUtil.findDirsUnder(file, thisDir));
            }
        }
        return dirs;
    }

    public static String convertToReadableSize(long sizelong) {
        double size = sizelong;
        for (int i = 0; i < SIZE_SPECIFIERS.length; ++i) {
            if (size < 1024.0) {
                return String.format("%.1f%c", size, Character.valueOf(SIZE_SPECIFIERS[i]));
            }
            size /= 1024.0;
        }
        throw new IllegalArgumentException(String.format("Passed a file size of %d, I cannot count that high", size));
    }

    public static long convertSizeToBytes(String sizeString) throws IllegalArgumentException {
        if (sizeString.isEmpty()) {
            throw new IllegalArgumentException("invalid empty string");
        }
        char sizeSpecifier = sizeString.charAt(sizeString.length() - 1);
        long multiplier = FileUtil.findMultiplier(sizeSpecifier);
        try {
            String numberString = sizeString;
            if (multiplier != 1L) {
                numberString = sizeString.substring(0, sizeString.length() - 1);
            }
            return multiplier * Long.parseLong(numberString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Unrecognized size %s", sizeString));
        }
    }

    private static long findMultiplier(char sizeSpecifier) {
        long multiplier = 1L;
        for (int i = 1; i < SIZE_SPECIFIERS.length; ++i) {
            multiplier *= 1024L;
            if (sizeSpecifier != SIZE_SPECIFIERS[i]) continue;
            return multiplier;
        }
        return 1L;
    }

    public static class LowDiskSpaceException
    extends FatalHostError {
        LowDiskSpaceException(String msg, Throwable cause) {
            super(msg, cause);
        }

        LowDiskSpaceException(String msg) {
            super(msg);
        }
    }
}

