/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public interface IEmail {
    public void send(Message var1) throws IllegalArgumentException, IOException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Message {
        static final String PLAIN = "text/plain";
        static final String HTML = "text/html";
        private Collection<String> mToAddrs = null;
        private Collection<String> mCcAddrs = null;
        private Collection<String> mBccAddrs = null;
        private String mSubject = null;
        private String mBody = null;
        private String mSender = null;
        private String mContentType = "text/plain";

        public Message() {
        }

        public Message(String to, String subject, String body) {
            this.addTo(to);
            this.setSubject(subject);
            this.setBody(body);
        }

        public void addTo(String address) {
            if (this.mToAddrs == null) {
                this.mToAddrs = new ArrayList<String>();
            }
            this.mToAddrs.add(address);
        }

        public void addCc(String address) {
            if (this.mCcAddrs == null) {
                this.mCcAddrs = new ArrayList<String>();
            }
            this.mCcAddrs.add(address);
        }

        public void addBcc(String address) {
            if (this.mBccAddrs == null) {
                this.mBccAddrs = new ArrayList<String>();
            }
            this.mBccAddrs.add(address);
        }

        public void setSubject(String subject) {
            this.mSubject = subject;
        }

        public void setTos(String[] recipients) {
            this.mToAddrs = Arrays.asList(recipients);
        }

        public void setBody(String body) {
            this.mBody = body;
        }

        public void setSender(String sender) {
            this.mSender = sender;
        }

        public void setContentType(String contentType) {
            if (contentType == null) {
                throw new NullPointerException();
            }
            this.mContentType = contentType;
        }

        public void setHtml(boolean html) {
            if (html) {
                this.setContentType(HTML);
            } else {
                this.setContentType(PLAIN);
            }
        }

        public Collection<String> getTo() {
            return this.mToAddrs;
        }

        public Collection<String> getCc() {
            return this.mCcAddrs;
        }

        public Collection<String> getBcc() {
            return this.mBccAddrs;
        }

        public String getSubject() {
            return this.mSubject;
        }

        public String getBody() {
            return this.mBody;
        }

        public String getSender() {
            return this.mSender;
        }

        public String getContentType() {
            return this.mContentType;
        }

        public boolean isHtml() {
            return HTML.equals(this.mContentType);
        }
    }
}

