/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexTrie<V> {
    private V mValue = null;
    private Map<CompPattern, RegexTrie<V>> mChildren = new LinkedHashMap<CompPattern, RegexTrie<V>>();

    public void clear() {
        this.mValue = null;
        for (RegexTrie<V> child : this.mChildren.values()) {
            child.clear();
        }
        this.mChildren.clear();
    }

    boolean containsKey(String ... strings) {
        return this.retrieve(strings) != null;
    }

    V recursivePut(V value, List<CompPattern> patterns) {
        if (patterns.isEmpty()) {
            V oldValue = this.mValue;
            this.mValue = value;
            return oldValue;
        }
        CompPattern curKey = patterns.get(0);
        List<CompPattern> nextKeys = patterns.subList(1, patterns.size());
        RegexTrie<V> nextChild = this.mChildren.get(curKey);
        if (nextChild == null) {
            nextChild = new RegexTrie<V>();
            this.mChildren.put(curKey, nextChild);
        }
        return nextChild.recursivePut(value, nextKeys);
    }

    private V validateAndPut(V value, List<CompPattern> pList) {
        if (pList.size() == 0) {
            throw new IllegalArgumentException("pattern list must be non-empty.");
        }
        return this.recursivePut(value, pList);
    }

    public V put(V value, Pattern ... patterns) {
        ArrayList<CompPattern> pList = new ArrayList<CompPattern>(patterns.length);
        for (Pattern pat : patterns) {
            if (pat == null) {
                pList.add(null);
                break;
            }
            pList.add(new CompPattern(pat));
        }
        return this.validateAndPut(value, pList);
    }

    public V put(V value, String ... regexen) {
        ArrayList<CompPattern> pList = new ArrayList<CompPattern>(regexen.length);
        for (String regex : regexen) {
            if (regex == null) {
                pList.add(null);
                break;
            }
            Pattern pat = Pattern.compile(regex);
            pList.add(new CompPattern(pat));
        }
        return this.validateAndPut(value, pList);
    }

    V recursiveRetrieve(List<List<String>> captures, List<String> strings) {
        if (strings.isEmpty()) {
            return this.mValue;
        }
        boolean wildcardMatch = false;
        V wildcardValue = null;
        String curKey = strings.get(0);
        List<String> nextKeys = strings.subList(1, strings.size());
        for (Map.Entry<CompPattern, RegexTrie<V>> child : this.mChildren.entrySet()) {
            CompPattern pattern = child.getKey();
            if (pattern == null) {
                wildcardMatch = true;
                wildcardValue = super.getValue();
                continue;
            }
            Matcher matcher = pattern.matcher(curKey);
            if (!matcher.matches()) continue;
            if (captures != null) {
                ArrayList<String> curCaptures = new ArrayList<String>(matcher.groupCount());
                for (int i = 0; i < matcher.groupCount(); ++i) {
                    curCaptures.add(matcher.group(i + 1));
                }
                captures.add(curCaptures);
            }
            return child.getValue().recursiveRetrieve(captures, nextKeys);
        }
        if (wildcardMatch) {
            if (captures != null) {
                for (String str : strings) {
                    captures.add(Arrays.asList(str));
                }
            }
            return wildcardValue;
        }
        return null;
    }

    public V retrieve(String ... strings) {
        return this.retrieve((List<List<String>>)null, strings);
    }

    public V retrieve(List<List<String>> captures, String ... strings) {
        if (strings.length == 0) {
            throw new IllegalArgumentException("string list must be non-empty");
        }
        List<String> sList = Arrays.asList(strings);
        if (captures != null) {
            captures.clear();
        }
        return this.recursiveRetrieve(captures, sList);
    }

    private V getValue() {
        return this.mValue;
    }

    public String toString() {
        return String.format("{V: %s, C: %s}", this.mValue, this.mChildren);
    }

    static class CompPattern {
        protected final Pattern mPattern;

        CompPattern(Pattern pattern) {
            if (pattern == null) {
                throw new NullPointerException();
            }
            this.mPattern = pattern;
        }

        public boolean equals(Object other) {
            Pattern otherPat;
            if (other instanceof Pattern) {
                otherPat = (Pattern)other;
            } else if (other instanceof CompPattern) {
                CompPattern otherCPat = (CompPattern)other;
                otherPat = otherCPat.mPattern;
            } else {
                return false;
            }
            return this.mPattern.toString().equals(otherPat.toString());
        }

        public int hashCode() {
            return this.mPattern.toString().hashCode();
        }

        public String toString() {
            return String.format("CP(%s)", this.mPattern.toString());
        }

        public Matcher matcher(String string) {
            return this.mPattern.matcher(string);
        }
    }
}

