/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleStats {
    private List<Double> mData = new LinkedList<Double>();
    private double mSum = 0.0;

    public void addAll(Collection<? extends Double> c) {
        for (Double d : c) {
            if (d == null) {
                throw new NullPointerException();
            }
            this.add(d);
        }
    }

    public void add(double meas) {
        this.mData.add(meas);
        this.mSum += meas;
    }

    public List<Double> getData() {
        return this.mData;
    }

    public boolean isEmpty() {
        return this.mData.isEmpty();
    }

    public int size() {
        return this.mData.size();
    }

    public Double mean() {
        if (this.isEmpty()) {
            return null;
        }
        return this.mSum / (double)this.size();
    }

    public Double median() {
        if (this.isEmpty()) {
            return null;
        }
        Collections.sort(this.mData);
        if ((this.mData.size() & 1) == 1) {
            int idx = this.size() / 2;
            return this.mData.get(idx);
        }
        int idx = this.size() / 2;
        return (this.mData.get(idx - 1) + this.mData.get(idx)) / 2.0;
    }

    public Double min() {
        if (this.isEmpty()) {
            return null;
        }
        Collections.sort(this.mData);
        return this.mData.get(0);
    }

    public Double max() {
        if (this.isEmpty()) {
            return null;
        }
        Collections.sort(this.mData);
        return this.mData.get(this.size() - 1);
    }

    public Double stdev() {
        if (this.isEmpty()) {
            return null;
        }
        Double avg = this.mean();
        Double ssd = 0.0;
        for (Double meas : this.mData) {
            Double diff = meas - avg;
            ssd = ssd + diff * diff;
        }
        return Math.sqrt(ssd / (double)this.size());
    }
}

