/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.util.ByteArrayList;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipOutputStream;

public class StreamUtil {
    private StreamUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringFromSource(InputStreamSource source) throws IOException {
        String contents;
        InputStream stream = source.createInputStream();
        try {
            contents = StreamUtil.getStringFromStream(stream);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            StreamUtil.close(stream);
            throw throwable;
        }
        StreamUtil.close(stream);
        return contents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayList getByteArrayListFromSource(InputStreamSource source) throws IOException {
        ByteArrayList contents;
        InputStream stream = source.createInputStream();
        try {
            contents = StreamUtil.getByteArrayListFromStream(stream);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            StreamUtil.close(stream);
            throw throwable;
        }
        StreamUtil.close(stream);
        return contents;
    }

    public static String getStringFromStream(InputStream stream) throws IOException {
        BufferedReader ir = new BufferedReader(new InputStreamReader(stream));
        int irChar = -1;
        StringBuilder builder = new StringBuilder();
        while ((irChar = ((Reader)ir).read()) != -1) {
            builder.append((char)irChar);
        }
        return builder.toString();
    }

    public static ByteArrayList getByteArrayListFromStream(InputStream stream) throws IOException {
        BufferedInputStream is = new BufferedInputStream(stream);
        int inputByte = -1;
        ByteArrayList list = new ByteArrayList();
        while ((inputByte = ((InputStream)is).read()) != -1) {
            list.add((byte)inputByte);
        }
        list.trimToSize();
        return list;
    }

    public static void copyStreams(InputStream inStream, OutputStream outStream) throws IOException {
        int data = -1;
        while ((data = inStream.read()) != -1) {
            outStream.write(data);
        }
    }

    public static void copyStreamToWriter(InputStream inStream, Writer writer) throws IOException {
        int data = -1;
        while ((data = inStream.read()) != -1) {
            writer.write(data);
        }
    }

    public static String getStackTrace(Throwable throwable) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintStream bytePrintStream = new PrintStream(outputStream);
        throwable.printStackTrace(bytePrintStream);
        return outputStream.toString();
    }

    @Deprecated
    public static void closeStream(OutputStream out) {
        StreamUtil.close(out);
    }

    @Deprecated
    public static void closeStream(InputStream in) {
        StreamUtil.close(in);
    }

    public static void flushAndCloseStream(OutputStream outStream) {
        if (outStream != null) {
            try {
                outStream.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                outStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeZipStream(ZipOutputStream outStream) {
        if (outStream != null) {
            try {
                outStream.closeEntry();
                outStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeGZipStream(GZIPOutputStream outStream) {
        if (outStream != null) {
            try {
                outStream.finish();
                outStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void cancel(InputStreamSource outputSource) {
        if (outputSource != null) {
            outputSource.cancel();
        }
    }
}

