/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class TimeUtil {
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private TimeUtil() {
    }

    public static String formatElapsedTime(long elapsedTimeMs) {
        if (elapsedTimeMs < 1000L) {
            return String.format("%d ms", elapsedTimeMs);
        }
        long seconds = TimeUnit.MILLISECONDS.toSeconds(elapsedTimeMs) % 60L;
        long minutes = TimeUnit.MILLISECONDS.toMinutes(elapsedTimeMs) % 60L;
        long hours = TimeUnit.MILLISECONDS.toHours(elapsedTimeMs);
        StringBuilder time = new StringBuilder();
        if (hours > 0L) {
            time.append(hours);
            time.append("h ");
        }
        if (minutes > 0L) {
            time.append(minutes);
            time.append("m ");
        }
        time.append(seconds);
        time.append("s");
        return time.toString();
    }

    public static String formatTimeStamp(long epochTime) {
        return TIME_FORMAT.format(new Date(epochTime));
    }
}

