/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.IOException;

public class VersionParser {
    private static final String DEFAULT_VERSION_FILE_NAME = "tf_version.txt";

    public static String fetchVersion(File file) {
        if (file.exists()) {
            try {
                return FileUtil.readStringFromFile(file);
            }
            catch (IOException e) {
                LogUtil.CLog.e(e.toString());
                return null;
            }
        }
        LogUtil.CLog.w("File %s does not exist, unable to get version", file.getAbsolutePath());
        return null;
    }

    public static String fetchVersion() {
        File file = new File(DEFAULT_VERSION_FILE_NAME);
        if (!file.exists()) {
            File path = new File(VersionParser.class.getProtectionDomain().getCodeSource().getLocation().getPath());
            file = new File(path.getParentFile(), DEFAULT_VERSION_FILE_NAME);
        }
        return VersionParser.fetchVersion(file);
    }
}

