/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.brillopad.item;

import com.android.tradefed.util.brillopad.item.GenericItem;
import com.android.tradefed.util.brillopad.item.GenericLogcatItem;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonkeyLogItem
extends GenericItem {
    private static final String TYPE = "MONKEY_LOG";
    private static final String START_TIME = "START_TIME";
    private static final String STOP_TIME = "STOP_TIME";
    private static final String PACKAGES = "PACKAGES";
    private static final String CATEGORIES = "CATEGORIES";
    private static final String THROTTLE = "THROTTLE";
    private static final String SEED = "SEED";
    private static final String TARGET_COUNT = "TARGET_COUNT";
    private static final String IGNORE_SECURITY_EXCEPTIONS = "IGNORE_SECURITY_EXCEPTIONS";
    private static final String TOTAL_DURATION = "TOTAL_TIME";
    private static final String START_UPTIME_DURATION = "START_UPTIME";
    private static final String STOP_UPTIME_DURATION = "STOP_UPTIME";
    private static final String IS_FINISHED = "IS_FINISHED";
    private static final String NO_ACTIVITIES = "NO_ACTIVITIES";
    private static final String INTERMEDIATE_COUNT = "INTERMEDIATE_COUNT";
    private static final String FINAL_COUNT = "FINAL_COUNT";
    private static final String CRASH = "CRASH";
    private static final Set<String> ATTRIBUTES = new HashSet<String>(Arrays.asList("START_TIME", "STOP_TIME", "PACKAGES", "CATEGORIES", "THROTTLE", "SEED", "TARGET_COUNT", "IGNORE_SECURITY_EXCEPTIONS", "TOTAL_TIME", "START_UPTIME", "STOP_UPTIME", "IS_FINISHED", "NO_ACTIVITIES", "INTERMEDIATE_COUNT", "FINAL_COUNT", "CRASH", DroppedCategory.KEYS.toString(), DroppedCategory.POINTERS.toString(), DroppedCategory.TRACKBALLS.toString(), DroppedCategory.FLIPS.toString(), DroppedCategory.ROTATIONS.toString()));

    public MonkeyLogItem() {
        super(TYPE, ATTRIBUTES);
        this.setAttribute(PACKAGES, new StringSet());
        this.setAttribute(CATEGORIES, new StringSet());
        this.setAttribute(THROTTLE, 0);
        this.setAttribute(IGNORE_SECURITY_EXCEPTIONS, false);
        this.setAttribute(IS_FINISHED, false);
        this.setAttribute(NO_ACTIVITIES, false);
        this.setAttribute(INTERMEDIATE_COUNT, 0);
    }

    public Date getStartTime() {
        return (Date)this.getAttribute(START_TIME);
    }

    public void setStartTime(Date time) {
        this.setAttribute(START_TIME, time);
    }

    public Date getStopTime() {
        return (Date)this.getAttribute(STOP_TIME);
    }

    public void setStopTime(Date time) {
        this.setAttribute(STOP_TIME, time);
    }

    public Set<String> getPackages() {
        return (StringSet)this.getAttribute(PACKAGES);
    }

    public void addPackage(String thePackage) {
        ((StringSet)this.getAttribute(PACKAGES)).add(thePackage);
    }

    public Set<String> getCategories() {
        return (StringSet)this.getAttribute(CATEGORIES);
    }

    public void addCategory(String category) {
        ((StringSet)this.getAttribute(CATEGORIES)).add(category);
    }

    public int getThrottle() {
        return (Integer)this.getAttribute(THROTTLE);
    }

    public void setThrottle(int throttle) {
        this.setAttribute(THROTTLE, throttle);
    }

    public Integer getSeed() {
        return (Integer)this.getAttribute(SEED);
    }

    public void setSeed(int seed) {
        this.setAttribute(SEED, seed);
    }

    public Integer getTargetCount() {
        return (Integer)this.getAttribute(TARGET_COUNT);
    }

    public void setTargetCount(int count) {
        this.setAttribute(TARGET_COUNT, count);
    }

    public boolean getIgnoreSecurityExceptions() {
        return (Boolean)this.getAttribute(IGNORE_SECURITY_EXCEPTIONS);
    }

    public void setIgnoreSecurityExceptions(boolean ignore) {
        this.setAttribute(IGNORE_SECURITY_EXCEPTIONS, ignore);
    }

    public Long getTotalDuration() {
        return (Long)this.getAttribute(TOTAL_DURATION);
    }

    public void setTotalDuration(long time) {
        this.setAttribute(TOTAL_DURATION, time);
    }

    public Long getStartUptimeDuration() {
        return (Long)this.getAttribute(START_UPTIME_DURATION);
    }

    public void setStartUptimeDuration(long uptime) {
        this.setAttribute(START_UPTIME_DURATION, uptime);
    }

    public Long getStopUptimeDuration() {
        return (Long)this.getAttribute(STOP_UPTIME_DURATION);
    }

    public void setStopUptimeDuration(long uptime) {
        this.setAttribute(STOP_UPTIME_DURATION, uptime);
    }

    public boolean getIsFinished() {
        return (Boolean)this.getAttribute(IS_FINISHED);
    }

    public void setIsFinished(boolean finished) {
        this.setAttribute(IS_FINISHED, finished);
    }

    public boolean getNoActivities() {
        return (Boolean)this.getAttribute(NO_ACTIVITIES);
    }

    public void setNoActivities(boolean noActivities) {
        this.setAttribute(NO_ACTIVITIES, noActivities);
    }

    public int getIntermediateCount() {
        return (Integer)this.getAttribute(INTERMEDIATE_COUNT);
    }

    public void setIntermediateCount(int count) {
        this.setAttribute(INTERMEDIATE_COUNT, count);
    }

    public Integer getFinalCount() {
        return (Integer)this.getAttribute(FINAL_COUNT);
    }

    public void setFinalCount(int count) {
        this.setAttribute(FINAL_COUNT, count);
    }

    public Integer getDroppedCount(DroppedCategory category) {
        return (Integer)this.getAttribute(category.toString());
    }

    public void setDroppedCount(DroppedCategory category, int count) {
        this.setAttribute(category.toString(), count);
    }

    public GenericLogcatItem getCrash() {
        return (GenericLogcatItem)this.getAttribute(CRASH);
    }

    public void setCrash(GenericLogcatItem crash) {
        this.setAttribute(CRASH, crash);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DroppedCategory {
        KEYS,
        POINTERS,
        TRACKBALLS,
        FLIPS,
        ROTATIONS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StringSet
    extends HashSet<String> {
        private static final long serialVersionUID = -2206822563602989856L;

        private StringSet() {
        }
    }
}

