/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.brillopad.item;

import com.android.tradefed.util.brillopad.item.ConflictingItemException;
import com.android.tradefed.util.brillopad.item.IItem;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcrankItem
implements IItem {
    public static final String TYPE = "PROCRANK";
    private Map<Integer, ProcrankValue> mProcrankLines = new HashMap<Integer, ProcrankValue>();

    public void addProcrankLine(int pid, String processName, int vss, int rss, int pss, int uss) {
        this.mProcrankLines.put(pid, new ProcrankValue(processName, vss, rss, pss, uss));
    }

    public Set<Integer> getPids() {
        return this.mProcrankLines.keySet();
    }

    public String getProcessName(int pid) {
        if (!this.mProcrankLines.containsKey(pid)) {
            return null;
        }
        return this.mProcrankLines.get((Object)Integer.valueOf((int)pid)).mProcessName;
    }

    public Integer getVss(int pid) {
        if (!this.mProcrankLines.containsKey(pid)) {
            return null;
        }
        return this.mProcrankLines.get((Object)Integer.valueOf((int)pid)).mVss;
    }

    public Integer getRss(int pid) {
        if (!this.mProcrankLines.containsKey(pid)) {
            return null;
        }
        return this.mProcrankLines.get((Object)Integer.valueOf((int)pid)).mRss;
    }

    public Integer getPss(int pid) {
        if (!this.mProcrankLines.containsKey(pid)) {
            return null;
        }
        return this.mProcrankLines.get((Object)Integer.valueOf((int)pid)).mPss;
    }

    public Integer getUss(int pid) {
        if (!this.mProcrankLines.containsKey(pid)) {
            return null;
        }
        return this.mProcrankLines.get((Object)Integer.valueOf((int)pid)).mUss;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public IItem merge(IItem other) throws ConflictingItemException {
        throw new ConflictingItemException("Procrank items cannot be merged");
    }

    @Override
    public boolean isConsistent(IItem other) {
        return false;
    }

    private class ProcrankValue {
        public String mProcessName = null;
        public int mVss;
        public int mRss;
        public int mPss;
        public int mUss;

        public ProcrankValue(String processName, int vss, int rss, int pss, int uss) {
            this.mProcessName = processName;
            this.mVss = vss;
            this.mRss = rss;
            this.mPss = pss;
            this.mUss = uss;
        }
    }
}

