/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.brillopad.parser;

import com.android.tradefed.util.brillopad.item.AnrItem;
import com.android.tradefed.util.brillopad.parser.IParser;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnrParser
implements IParser {
    public static final Pattern START = Pattern.compile("^ANR (?:\\(application not responding\\) )?in (?:process: )?(\\S+).*$");
    private static final Pattern REASON = Pattern.compile("^Reason: (.*)$");
    private static final Pattern LOAD = Pattern.compile("^Load: (\\d+\\.\\d+) / (\\d+\\.\\d+) / (\\d+\\.\\d+)$");
    private static final Pattern TOTAL = Pattern.compile("^(\\d+(\\.\\d+)?)% TOTAL: .*$");
    private static final Pattern USER = Pattern.compile("^.* (\\d+(\\.\\d+)?)% user.*$");
    private static final Pattern KERNEL = Pattern.compile("^.* (\\d+(\\.\\d+)?)% kernel.*$");
    private static final Pattern IOWAIT = Pattern.compile("^.* (\\d+(\\.\\d+)?)% iowait.*$");

    @Override
    public AnrItem parse(List<String> lines) {
        AnrItem anr = null;
        StringBuilder stack = new StringBuilder();
        boolean matchedTotal = false;
        for (String line : lines) {
            Matcher m = START.matcher(line);
            if (m.matches()) {
                anr = new AnrItem();
                anr.setApp(m.group(1));
            }
            if (anr == null) continue;
            m = REASON.matcher(line);
            if (m.matches()) {
                anr.setReason(m.group(1));
            }
            if ((m = LOAD.matcher(line)).matches()) {
                anr.setLoad(AnrItem.LoadCategory.LOAD_1, Double.parseDouble(m.group(1)));
                anr.setLoad(AnrItem.LoadCategory.LOAD_5, Double.parseDouble(m.group(2)));
                anr.setLoad(AnrItem.LoadCategory.LOAD_15, Double.parseDouble(m.group(3)));
            }
            m = TOTAL.matcher(line);
            if (!matchedTotal && m.matches()) {
                matchedTotal = true;
                anr.setCpuUsage(AnrItem.CpuUsageCategory.TOTAL, Double.parseDouble(m.group(1)));
                m = USER.matcher(line);
                Double usage = m.matches() ? Double.parseDouble(m.group(1)) : 0.0;
                anr.setCpuUsage(AnrItem.CpuUsageCategory.USER, usage);
                m = KERNEL.matcher(line);
                usage = m.matches() ? Double.parseDouble(m.group(1)) : 0.0;
                anr.setCpuUsage(AnrItem.CpuUsageCategory.KERNEL, usage);
                m = IOWAIT.matcher(line);
                usage = m.matches() ? Double.parseDouble(m.group(1)) : 0.0;
                anr.setCpuUsage(AnrItem.CpuUsageCategory.IOWAIT, usage);
            }
            stack.append(line);
            stack.append("\n");
        }
        if (anr != null) {
            anr.setStack(stack.toString().trim());
        }
        return anr;
    }
}

