/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.brillopad.parser;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.util.brillopad.item.AnrItem;
import com.android.tradefed.util.brillopad.item.BugreportItem;
import com.android.tradefed.util.brillopad.item.GenericLogcatItem;
import com.android.tradefed.util.brillopad.item.IItem;
import com.android.tradefed.util.brillopad.item.LogcatItem;
import com.android.tradefed.util.brillopad.item.MemInfoItem;
import com.android.tradefed.util.brillopad.item.ProcrankItem;
import com.android.tradefed.util.brillopad.item.SystemPropsItem;
import com.android.tradefed.util.brillopad.item.TracesItem;
import com.android.tradefed.util.brillopad.parser.AbstractSectionParser;
import com.android.tradefed.util.brillopad.parser.IParser;
import com.android.tradefed.util.brillopad.parser.LogcatParser;
import com.android.tradefed.util.brillopad.parser.MemInfoParser;
import com.android.tradefed.util.brillopad.parser.NoopParser;
import com.android.tradefed.util.brillopad.parser.ProcrankParser;
import com.android.tradefed.util.brillopad.parser.SystemPropsParser;
import com.android.tradefed.util.brillopad.parser.TracesParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugreportParser
extends AbstractSectionParser {
    private static final String MEM_INFO_SECTION_REGEX = "------ MEMORY INFO .*";
    private static final String PROCRANK_SECTION_REGEX = "------ PROCRANK .*";
    private static final String SYSTEM_PROP_SECTION_REGEX = "------ SYSTEM PROPERTIES .*";
    private static final String SYSTEM_LOG_SECTION_REGEX = "------ (SYSTEM|MAIN|MAIN AND SYSTEM) LOG .*";
    private static final String ANR_TRACES_SECTION_REGEX = "------ VM TRACES AT LAST ANR .*";
    private static final String NOOP_SECTION_REGEX = "------ .*";
    private static final Pattern DATE = Pattern.compile("^== dumpstate: (\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2})$");
    private LogcatParser mLogcatParser = new LogcatParser();
    private BugreportItem mBugreport = null;

    public BugreportItem parse(BufferedReader input) throws IOException {
        String line;
        this.setup();
        while ((line = input.readLine()) != null) {
            this.parseLine(line);
        }
        this.commit();
        return this.mBugreport;
    }

    public BugreportItem parse(InputStreamSource input) throws IOException {
        InputStream stream = input.createInputStream();
        return this.parse(new BufferedReader(new InputStreamReader(stream)));
    }

    @Override
    public BugreportItem parse(List<String> lines) {
        this.setup();
        for (String line : lines) {
            this.parseLine(line);
        }
        this.commit();
        return this.mBugreport;
    }

    protected void setup() {
        this.setParser(new IParser(){

            @Override
            public BugreportItem parse(List<String> lines) {
                BugreportItem bugreport = new BugreportItem();
                for (String line : lines) {
                    Matcher m = DATE.matcher(line);
                    if (!m.matches()) continue;
                    bugreport.setTime(BugreportParser.parseTime(m.group(1)));
                }
                return bugreport;
            }
        });
        this.addSectionParser(new MemInfoParser(), MEM_INFO_SECTION_REGEX);
        this.addSectionParser(new ProcrankParser(), PROCRANK_SECTION_REGEX);
        this.addSectionParser(new SystemPropsParser(), SYSTEM_PROP_SECTION_REGEX);
        this.addSectionParser(new TracesParser(), ANR_TRACES_SECTION_REGEX);
        this.addSectionParser(this.mLogcatParser, SYSTEM_LOG_SECTION_REGEX);
        this.addSectionParser(new NoopParser(), NOOP_SECTION_REGEX);
    }

    @Override
    protected void commit() {
        super.commit();
        if (this.mBugreport != null) {
            TracesItem traces;
            this.mBugreport.setMemInfo((MemInfoItem)this.getSection("MEMORY INFO"));
            this.mBugreport.setProcrank((ProcrankItem)this.getSection("PROCRANK"));
            this.mBugreport.setSystemLog((LogcatItem)this.getSection("LOGCAT"));
            this.mBugreport.setSystemProps((SystemPropsItem)this.getSection("SYSTEM PROPERTIES"));
            if (this.mBugreport.getSystemLog() != null && this.mBugreport.getProcrank() != null) {
                for (IItem item : this.mBugreport.getSystemLog().getEvents()) {
                    if (!(item instanceof GenericLogcatItem) || ((GenericLogcatItem)item).getApp() != null) continue;
                    GenericLogcatItem logcatItem = (GenericLogcatItem)item;
                    logcatItem.setApp(this.mBugreport.getProcrank().getProcessName(logcatItem.getPid()));
                }
            }
            if ((traces = (TracesItem)this.getSection("TRACES_ITEM")) != null && traces.getApp() != null && traces.getStack() != null && this.mBugreport.getSystemLog() != null) {
                this.addAnrTrace(this.mBugreport.getSystemLog().getAnrs(), traces.getApp(), traces.getStack());
            }
        }
    }

    private void addAnrTrace(List<AnrItem> anrs, String app, String trace) {
        ListIterator<AnrItem> li = anrs.listIterator(anrs.size());
        while (li.hasPrevious()) {
            AnrItem anr = li.previous();
            if (!app.equals(anr.getApp())) continue;
            anr.setTrace(trace);
            return;
        }
    }

    @Override
    protected void onSwitchParser() {
        if (this.mBugreport == null) {
            this.mBugreport = (BugreportItem)this.getSection("BUGREPORT");
            if (this.mBugreport.getTime() != null) {
                this.mLogcatParser.setYear(new SimpleDateFormat("yyyy").format(this.mBugreport.getTime()));
            }
        }
    }

    private static Date parseTime(String timeStr) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return formatter.parse(timeStr);
        }
        catch (ParseException e) {
            LogUtil.CLog.e("Could not parse time string %s", timeStr);
            return null;
        }
    }
}

